/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.PlanTimeProfile;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.CoordinatorRewriteContext;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.core.util.Queries;
import org.elasticsearch.xpack.esql.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamWrapperQueryBuilder;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.plan.QueryPlan;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.PipelineBreaker;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.LookupJoinExec;
import org.elasticsearch.xpack.esql.plan.physical.MergeExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;
import org.elasticsearch.xpack.esql.planner.PlannerSettings;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.planner.mapper.LocalMapper;
import org.elasticsearch.xpack.esql.plugin.EsqlFlags;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.stats.SearchContextStats;
import org.elasticsearch.xpack.esql.stats.SearchStats;

public class PlannerUtils {
    private static final Logger LOGGER = LogManager.getLogger(PlannerUtils.class);
    @Deprecated(forRemoval=true)
    public static final BlockFactory NON_BREAKING_BLOCK_FACTORY = BlockFactory.getInstance((CircuitBreaker)new NoopCircuitBreaker("noop-esql-breaker"), (BigArrays)BigArrays.NON_RECYCLING_INSTANCE);

    public static Tuple<List<PhysicalPlan>, PhysicalPlan> breakPlanIntoSubPlansAndMainPlan(PhysicalPlan plan) {
        Holder subplans = new Holder();
        PhysicalPlan mainPlan = plan.transformUp(MergeExec.class, me -> {
            subplans.set(me.children().stream().map(child -> new ExchangeSinkExec(child.source(), child.output(), false, (PhysicalPlan)child)).toList());
            return new ExchangeSourceExec(me.source(), me.output(), false);
        });
        return new Tuple((Object)((List)subplans.get()), (Object)mainPlan);
    }

    public static Tuple<PhysicalPlan, PhysicalPlan> breakPlanBetweenCoordinatorAndDataNode(PhysicalPlan plan, Configuration config) {
        Holder dataNodePlan = new Holder();
        PhysicalPlan coordinatorPlan = plan.transformUp(ExchangeExec.class, e -> {
            PhysicalPlan subplan = e.child();
            dataNodePlan.set((Object)new ExchangeSinkExec(e.source(), e.output(), e.inBetweenAggs(), subplan));
            return new ExchangeSourceExec(e.source(), e.output(), e.inBetweenAggs());
        });
        return new Tuple((Object)coordinatorPlan, (Object)((PhysicalPlan)dataNodePlan.get()));
    }

    public static PlanReduction reductionPlan(PhysicalPlan plan) {
        List<PhysicalPlan> fragments = plan.collectFirstChildren(p -> p instanceof FragmentExec);
        if (fragments.isEmpty()) {
            return SimplePlanReduction.NO_REDUCTION;
        }
        FragmentExec fragment = (FragmentExec)fragments.getFirst();
        List<LogicalPlan> pipelineBreakers = fragment.fragment().collectFirstChildren(p -> p instanceof PipelineBreaker);
        if (pipelineBreakers.isEmpty()) {
            return SimplePlanReduction.NO_REDUCTION;
        }
        LogicalPlan pipelineBreaker = pipelineBreakers.getFirst();
        int estimatedRowSize = fragment.estimatedRowSize();
        PhysicalPlan physicalPlan = LocalMapper.INSTANCE.map(pipelineBreaker);
        Objects.requireNonNull(physicalPlan);
        PhysicalPlan physicalPlan2 = physicalPlan;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TopNExec.class, AggregateExec.class, PhysicalPlan.class}, (Object)physicalPlan2, n)) {
            case 0 -> {
                TopNExec topN = (TopNExec)physicalPlan2;
                yield new TopNReduction(EstimatesRowSize.estimateRowSize(estimatedRowSize, topN));
            }
            case 1 -> {
                AggregateExec aggExec = (AggregateExec)physicalPlan2;
                yield PlannerUtils.getPhysicalPlanReduction(estimatedRowSize, aggExec.withMode(AggregatorMode.INTERMEDIATE));
            }
            default -> {
                PhysicalPlan p = physicalPlan2;
                yield PlannerUtils.getPhysicalPlanReduction(estimatedRowSize, p);
            }
        };
    }

    private static ReducedPlan getPhysicalPlanReduction(int estimatedRowSize, PhysicalPlan plan) {
        return new ReducedPlan(EstimatesRowSize.estimateRowSize(estimatedRowSize, plan));
    }

    public static boolean requiresSortedTimeSeriesSource(PhysicalPlan plan) {
        return plan.anyMatch(e -> {
            if (e instanceof FragmentExec) {
                FragmentExec f = (FragmentExec)e;
                return f.fragment().anyMatch(l -> {
                    EsRelation r;
                    return l instanceof EsRelation && (r = (EsRelation)l).indexMode() == IndexMode.TIME_SERIES;
                });
            }
            return false;
        });
    }

    public static void forEachRelation(PhysicalPlan plan, Consumer<EsRelation> action) {
        plan.forEachDown(FragmentExec.class, f -> f.fragment().forEachDown(EsRelation.class, r -> {
            if (r.indexMode() != IndexMode.LOOKUP) {
                action.accept((EsRelation)r);
            }
        }));
    }

    public static PhysicalPlan localPlan(PlannerSettings plannerSettings, EsqlFlags flags, List<SearchExecutionContext> searchContexts, Configuration configuration, FoldContext foldCtx, PhysicalPlan plan, PlanTimeProfile planTimeProfile) {
        return PlannerUtils.localPlan(plannerSettings, flags, configuration, foldCtx, plan, SearchContextStats.from(searchContexts), planTimeProfile);
    }

    public static PhysicalPlan localPlan(PlannerSettings plannerSettings, EsqlFlags flags, Configuration configuration, FoldContext foldCtx, PhysicalPlan plan, SearchStats searchStats, PlanTimeProfile planTimeProfile) {
        LocalLogicalPlanOptimizer logicalOptimizer = new LocalLogicalPlanOptimizer(new LocalLogicalOptimizerContext(configuration, foldCtx, searchStats));
        LocalPhysicalPlanOptimizer physicalOptimizer = new LocalPhysicalPlanOptimizer(new LocalPhysicalOptimizerContext(plannerSettings, flags, configuration, foldCtx, searchStats));
        return PlannerUtils.localPlan(plan, logicalOptimizer, physicalOptimizer, planTimeProfile);
    }

    public static PhysicalPlan integrateEsFilterIntoFragment(PhysicalPlan plan, @Nullable QueryBuilder esFilter) {
        return esFilter == null ? plan : plan.transformUp(FragmentExec.class, f -> {
            QueryBuilder fragmentFilter = f.esFilter();
            QueryBuilder filter = fragmentFilter != null ? QueryBuilders.boolQuery().filter(fragmentFilter).must(esFilter) : esFilter;
            LOGGER.debug("Fold filter {} to EsQueryExec", new Object[]{filter});
            return f.withFilter(filter);
        });
    }

    public static PhysicalPlan localPlan(PhysicalPlan plan, LocalLogicalPlanOptimizer logicalOptimizer, LocalPhysicalPlanOptimizer physicalOptimizer, PlanTimeProfile planTimeProfile) {
        Holder isCoordPlan = new Holder((Object)Boolean.TRUE);
        Set lookupJoinExecRightChildren = plan.collect(LookupJoinExec.class::isInstance).stream().map(x -> ((LookupJoinExec)x).right()).collect(Collectors.toSet());
        PhysicalPlan localPhysicalPlan = plan.transformUp(FragmentExec.class, f -> {
            QueryBuilder filter;
            if (lookupJoinExecRightChildren.contains(f)) {
                return f;
            }
            isCoordPlan.set((Object)Boolean.FALSE);
            boolean profilingEnabled = planTimeProfile != null;
            long logicalStartNanos = profilingEnabled ? System.nanoTime() : 0L;
            LogicalPlan optimizedFragment = logicalOptimizer.localOptimize(f.fragment());
            PhysicalPlan physicalFragment = LocalMapper.INSTANCE.map(optimizedFragment);
            if (profilingEnabled) {
                planTimeProfile.addLogicalOptimizationPlanTime(System.nanoTime() - logicalStartNanos);
            }
            if ((filter = f.esFilter()) != null) {
                physicalFragment = physicalFragment.transformUp(EsSourceExec.class, query -> new EsSourceExec(Source.EMPTY, query.indexPattern(), query.indexMode(), query.output(), filter));
            }
            long physicalStartNanos = profilingEnabled ? System.nanoTime() : 0L;
            PhysicalPlan localOptimized = physicalOptimizer.localOptimize(physicalFragment);
            if (profilingEnabled) {
                planTimeProfile.addPhysicalOptimizationPlanTime(System.nanoTime() - physicalStartNanos);
            }
            return EstimatesRowSize.estimateRowSize(f.estimatedRowSize(), localOptimized);
        });
        PhysicalPlan resultPlan = (Boolean)isCoordPlan.get() != false ? plan : localPhysicalPlan;
        return resultPlan;
    }

    public static QueryBuilder canMatchFilter(EsqlFlags flags, Configuration configuration, TransportVersion minTransportVersion, PhysicalPlan plan) {
        return PlannerUtils.detectFilter(flags, configuration, minTransportVersion, plan, CoordinatorRewriteContext.SUPPORTED_FIELDS::contains);
    }

    static QueryBuilder detectFilter(EsqlFlags flags, Configuration configuration, TransportVersion minTransportVersion, PhysicalPlan plan, Predicate<String> fieldName) {
        ArrayList<QueryBuilder> requestFilters = new ArrayList<QueryBuilder>();
        LucenePushdownPredicates ctx = LucenePushdownPredicates.forCanMatch(minTransportVersion, flags);
        plan.forEachDown(FragmentExec.class, fe -> {
            if (fe.esFilter() != null && fe.esFilter().supportsVersion(minTransportVersion)) {
                requestFilters.add(fe.esFilter());
            }
            fe.fragment().forEachUp(Filter.class, f -> {
                ArrayList<Expression> matches = new ArrayList<Expression>();
                if (f.child() instanceof EsRelation) {
                    List<Expression> conjunctions = Predicates.splitAnd(f.condition());
                    for (Expression exp : conjunctions) {
                        AttributeSet.Builder refsBuilder = AttributeSet.builder().addAll(exp.references());
                        boolean matchesField = refsBuilder.removeIf(e -> fieldName.test(e.name()));
                        if (!matchesField || !refsBuilder.isEmpty() || TranslationAware.translatable(exp, ctx).finish() != TranslationAware.FinishedTranslatable.YES) continue;
                        matches.add(exp);
                    }
                }
                if (!matches.isEmpty()) {
                    Query qlQuery = TranslatorHandler.TRANSLATOR_HANDLER.asQuery(ctx, Predicates.combineAnd(matches));
                    QueryBuilder builder = qlQuery.toQueryBuilder();
                    if (qlQuery.containsPlan()) {
                        builder = new PlanStreamWrapperQueryBuilder(configuration, builder);
                    }
                    requestFilters.add(builder);
                }
            });
        });
        return Queries.combine(Queries.Clause.FILTER, requestFilters);
    }

    public static ElementType toSortableElementType(DataType dataType) {
        if (DataType.isSpatialOrGrid(dataType)) {
            return ElementType.UNKNOWN;
        }
        return PlannerUtils.toElementType(dataType);
    }

    public static ElementType toElementType(DataType dataType) {
        return PlannerUtils.toElementType(dataType, MappedFieldType.FieldExtractPreference.NONE);
    }

    public static ElementType toElementType(DataType dataType, MappedFieldType.FieldExtractPreference fieldExtractPreference) {
        return switch (dataType) {
            default -> throw new MatchException(null, null);
            case DataType.LONG, DataType.DATETIME, DataType.DATE_NANOS, DataType.UNSIGNED_LONG, DataType.COUNTER_LONG, DataType.GEOHASH, DataType.GEOTILE, DataType.GEOHEX -> ElementType.LONG;
            case DataType.INTEGER, DataType.COUNTER_INTEGER -> ElementType.INT;
            case DataType.DOUBLE, DataType.COUNTER_DOUBLE -> ElementType.DOUBLE;
            case DataType.KEYWORD, DataType.TEXT, DataType.IP, DataType.SOURCE, DataType.VERSION, DataType.HISTOGRAM, DataType.UNSUPPORTED -> ElementType.BYTES_REF;
            case DataType.NULL -> ElementType.NULL;
            case DataType.BOOLEAN -> ElementType.BOOLEAN;
            case DataType.DOC_DATA_TYPE -> ElementType.DOC;
            case DataType.TSID_DATA_TYPE -> ElementType.BYTES_REF;
            case DataType.GEO_POINT, DataType.CARTESIAN_POINT -> {
                if (fieldExtractPreference == MappedFieldType.FieldExtractPreference.DOC_VALUES) {
                    yield ElementType.LONG;
                }
                yield ElementType.BYTES_REF;
            }
            case DataType.GEO_SHAPE, DataType.CARTESIAN_SHAPE -> {
                if (fieldExtractPreference == MappedFieldType.FieldExtractPreference.EXTRACT_SPATIAL_BOUNDS) {
                    yield ElementType.INT;
                }
                yield ElementType.BYTES_REF;
            }
            case DataType.AGGREGATE_METRIC_DOUBLE -> ElementType.AGGREGATE_METRIC_DOUBLE;
            case DataType.EXPONENTIAL_HISTOGRAM -> ElementType.EXPONENTIAL_HISTOGRAM;
            case DataType.TDIGEST -> ElementType.TDIGEST;
            case DataType.DENSE_VECTOR -> ElementType.FLOAT;
            case DataType.SHORT, DataType.BYTE, DataType.DATE_PERIOD, DataType.TIME_DURATION, DataType.OBJECT, DataType.FLOAT, DataType.HALF_FLOAT, DataType.SCALED_FLOAT -> throw EsqlIllegalArgumentException.illegalDataType(dataType);
        };
    }

    public static boolean usesScoring(QueryPlan<?> plan) {
        return plan.output().stream().anyMatch(attr -> {
            MetadataAttribute ma;
            return attr instanceof MetadataAttribute && (ma = (MetadataAttribute)attr).name().equals("_score");
        });
    }

    public static enum SimplePlanReduction implements PlanReduction
    {
        NO_REDUCTION;

    }

    public record TopNReduction(PhysicalPlan plan) implements PlanReduction
    {
    }

    public record ReducedPlan(PhysicalPlan plan) implements PlanReduction
    {
    }

    public static sealed interface PlanReduction
    permits SimplePlanReduction, TopNReduction, ReducedPlan {
    }
}

