/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical.inference;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.esql.plan.physical.inference.InferenceExec;

public class CompletionExec
extends InferenceExec {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "CompletionExec", CompletionExec::new);
    private final Expression prompt;
    private final Attribute targetField;
    private List<Attribute> lazyOutput;

    public CompletionExec(Source source, PhysicalPlan child, Expression inferenceId, Expression prompt, Attribute targetField) {
        super(source, child, inferenceId);
        this.prompt = prompt;
        this.targetField = targetField;
    }

    public CompletionExec(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Attribute)in.readNamedWriteable(Attribute.class));
    }

    public String getWriteableName() {
        return CompletionExec.ENTRY.name;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.prompt);
        out.writeNamedWriteable((NamedWriteable)this.targetField);
    }

    public Expression prompt() {
        return this.prompt;
    }

    public Attribute targetField() {
        return this.targetField;
    }

    @Override
    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create(this, CompletionExec::new, this.child(), this.inferenceId(), this.prompt, this.targetField);
    }

    @Override
    public UnaryExec replaceChild(PhysicalPlan newChild) {
        return new CompletionExec(this.source(), newChild, this.inferenceId(), this.prompt, this.targetField);
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = NamedExpressions.mergeOutputAttributes(List.of(this.targetField), this.child().output());
        }
        return this.lazyOutput;
    }

    @Override
    protected AttributeSet computeReferences() {
        return this.prompt.references();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompletionExec completion = (CompletionExec)o;
        return Objects.equals(this.prompt, completion.prompt) && Objects.equals(this.targetField, completion.targetField);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.prompt, this.targetField);
    }
}

