/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class ShowExec
extends LeafExec {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "ShowExec", ShowExec::new);
    private final List<Attribute> attributes;
    private final List<List<Object>> values;

    public ShowExec(Source source, List<Attribute> attributes, List<List<Object>> values) {
        super(source);
        this.attributes = attributes;
        this.values = values;
    }

    private ShowExec(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), in.readNamedWriteableCollectionAsList(Attribute.class), (List)in.readGenericValue());
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteableCollection(this.output());
        out.writeGenericValue(this.values());
    }

    public String getWriteableName() {
        return ShowExec.ENTRY.name;
    }

    @Override
    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create(this, ShowExec::new, this.attributes, this.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attributes, this.values);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShowExec)) return false;
        ShowExec other = (ShowExec)obj;
        if (!Objects.equals(this.attributes, other.attributes)) return false;
        if (!Objects.equals(this.values, other.values)) return false;
        return true;
    }

    @Override
    public List<Attribute> output() {
        return this.attributes;
    }

    public List<List<Object>> values() {
        return this.values;
    }
}

