/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class ProjectExec
extends UnaryExec {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "ProjectExec", ProjectExec::new);
    private final List<? extends NamedExpression> projections;

    public ProjectExec(Source source, PhysicalPlan child, List<? extends NamedExpression> projections) {
        super(source, child);
        this.projections = projections;
    }

    private ProjectExec(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class), in.readNamedWriteableCollectionAsList(NamedExpression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteableCollection(this.projections());
    }

    public String getWriteableName() {
        return ProjectExec.ENTRY.name;
    }

    @Override
    protected NodeInfo<ProjectExec> info() {
        return NodeInfo.create(this, ProjectExec::new, this.child(), this.projections);
    }

    @Override
    public ProjectExec replaceChild(PhysicalPlan newChild) {
        return new ProjectExec(this.source(), newChild, this.projections);
    }

    public List<? extends NamedExpression> projections() {
        return this.projections;
    }

    @Override
    public List<Attribute> output() {
        return Expressions.asAttributes(this.projections);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.projections, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectExec other = (ProjectExec)obj;
        return Objects.equals(this.projections, other.projections) && Objects.equals(this.child(), other.child());
    }
}

