/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class MergeExec
extends PhysicalPlan {
    private final List<Attribute> output;

    public MergeExec(Source source, List<PhysicalPlan> children, List<Attribute> output) {
        super(source, children);
        this.output = output;
    }

    public List<LocalSupplier> suppliers() {
        return this.children().stream().map(LocalSourceExec.class::cast).map(LocalSourceExec::supplier).toList();
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    @Override
    public PhysicalPlan replaceChildren(List<PhysicalPlan> newChildren) {
        return new MergeExec(this.source(), newChildren, this.output());
    }

    @Override
    protected NodeInfo<MergeExec> info() {
        return NodeInfo.create(this, MergeExec::new, this.children(), this.output);
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.children());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeExec other = (MergeExec)o;
        return Objects.equals(this.children(), other.children());
    }
}

