/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.BinaryExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class LookupJoinExec
extends BinaryExec
implements EstimatesRowSize {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "LookupJoinExec", LookupJoinExec::new);
    private static final TransportVersion ESQL_LOOKUP_JOIN_ON_EXPRESSION = TransportVersion.fromName((String)"esql_lookup_join_on_expression");
    private final List<Attribute> leftFields;
    private final List<Attribute> rightFields;
    private final List<Attribute> addedFields;
    private final Expression joinOnConditions;
    private List<Attribute> lazyOutput;

    public LookupJoinExec(Source source, PhysicalPlan left, PhysicalPlan lookup, List<Attribute> leftFields, List<Attribute> rightFields, List<Attribute> addedFields, Expression joinOnConditions) {
        super(source, left, lookup);
        this.leftFields = leftFields;
        this.rightFields = rightFields;
        this.addedFields = addedFields;
        this.joinOnConditions = joinOnConditions;
    }

    private LookupJoinExec(StreamInput in) throws IOException {
        super(Source.readFrom((PlanStreamInput)in), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class));
        this.leftFields = in.readNamedWriteableCollectionAsList(Attribute.class);
        this.rightFields = in.readNamedWriteableCollectionAsList(Attribute.class);
        this.addedFields = in.readNamedWriteableCollectionAsList(Attribute.class);
        this.joinOnConditions = in.getTransportVersion().supports(ESQL_LOOKUP_JOIN_ON_EXPRESSION) ? (Expression)in.readOptionalNamedWriteable(Expression.class) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteableCollection(this.leftFields);
        out.writeNamedWriteableCollection(this.rightFields);
        out.writeNamedWriteableCollection(this.addedFields);
        if (out.getTransportVersion().supports(ESQL_LOOKUP_JOIN_ON_EXPRESSION)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.joinOnConditions);
        } else if (this.joinOnConditions != null) {
            throw new IllegalArgumentException("LOOKUP JOIN with ON conditions is not supported on remote node");
        }
    }

    public String getWriteableName() {
        return LookupJoinExec.ENTRY.name;
    }

    public PhysicalPlan lookup() {
        return this.right();
    }

    public List<Attribute> leftFields() {
        return this.leftFields;
    }

    public List<Attribute> rightFields() {
        return this.rightFields;
    }

    public List<Attribute> addedFields() {
        return this.addedFields;
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = new ArrayList<Attribute>(this.left().output());
            List<String> addedFieldsNames = this.addedFields.stream().map(NamedExpression::name).toList();
            this.lazyOutput.removeIf(a -> addedFieldsNames.contains(a.name()));
            this.lazyOutput.addAll(this.addedFields);
        }
        return this.lazyOutput;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(false, this.addedFields);
        return this;
    }

    @Override
    public AttributeSet inputSet() {
        return this.left().outputSet();
    }

    @Override
    protected AttributeSet computeReferences() {
        return Expressions.references(this.leftFields);
    }

    @Override
    public AttributeSet leftReferences() {
        return Expressions.references(this.leftFields);
    }

    @Override
    public AttributeSet rightReferences() {
        return AttributeSet.EMPTY;
    }

    @Override
    public LookupJoinExec replaceChildren(PhysicalPlan left, PhysicalPlan right) {
        return new LookupJoinExec(this.source(), left, right, this.leftFields, this.rightFields, this.addedFields, this.joinOnConditions);
    }

    @Override
    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create(this, LookupJoinExec::new, this.left(), this.right(), this.leftFields, this.rightFields, this.addedFields, this.joinOnConditions);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LookupJoinExec other = (LookupJoinExec)o;
        return this.leftFields.equals(other.leftFields) && this.rightFields.equals(other.rightFields) && this.addedFields.equals(other.addedFields) && Objects.equals(this.joinOnConditions, other.joinOnConditions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.leftFields, this.rightFields, this.addedFields, this.joinOnConditions);
    }

    public boolean isOnJoinExpression() {
        return this.joinOnConditions != null;
    }

    public Expression joinOnConditions() {
        return this.joinOnConditions;
    }
}

