/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class LimitExec
extends UnaryExec
implements EstimatesRowSize {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "LimitExec", LimitExec::new);
    private static final TransportVersion ESQL_LIMIT_ROW_SIZE = TransportVersion.fromName((String)"esql_limit_row_size");
    private final Expression limit;
    private final Integer estimatedRowSize;

    public LimitExec(Source source, PhysicalPlan child, Expression limit, Integer estimatedRowSize) {
        super(source, child);
        this.limit = limit;
        this.estimatedRowSize = estimatedRowSize;
    }

    private LimitExec(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class), (Expression)in.readNamedWriteable(Expression.class), in.getTransportVersion().supports(ESQL_LIMIT_ROW_SIZE) ? in.readOptionalVInt() : null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteable((NamedWriteable)this.limit());
        if (out.getTransportVersion().supports(ESQL_LIMIT_ROW_SIZE)) {
            out.writeOptionalVInt(this.estimatedRowSize);
        }
    }

    public String getWriteableName() {
        return LimitExec.ENTRY.name;
    }

    @Override
    protected NodeInfo<? extends LimitExec> info() {
        return NodeInfo.create(this, LimitExec::new, this.child(), this.limit, this.estimatedRowSize);
    }

    @Override
    public LimitExec replaceChild(PhysicalPlan newChild) {
        return new LimitExec(this.source(), newChild, this.limit, this.estimatedRowSize);
    }

    public Expression limit() {
        return this.limit;
    }

    public Integer estimatedRowSize() {
        return this.estimatedRowSize;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State unused) {
        List<Attribute> output = this.output();
        EstimatesRowSize.State state = new EstimatesRowSize.State();
        boolean needsSortedDocIds = output.stream().anyMatch(a -> a.dataType() == DataType.DOC_DATA_TYPE);
        state.add(needsSortedDocIds, output);
        int size = state.consumeAllFields(true);
        size = Math.max(size, 1);
        return Objects.equals(this.estimatedRowSize, size) ? this : new LimitExec(this.source(), this.child(), this.limit, size);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.limit, this.estimatedRowSize, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LimitExec other = (LimitExec)obj;
        return Objects.equals(this.limit, other.limit) && Objects.equals(this.estimatedRowSize, other.estimatedRowSize) && Objects.equals(this.child(), other.child());
    }
}

