/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class FieldExtractExec
extends UnaryExec
implements EstimatesRowSize {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "FieldExtractExec", FieldExtractExec::new);
    protected final List<Attribute> attributesToExtract;
    @Nullable
    protected final Attribute sourceAttribute;
    protected final MappedFieldType.FieldExtractPreference defaultPreference;
    protected final Set<Attribute> docValuesAttributes;
    protected final Set<Attribute> boundsAttributes;
    private List<Attribute> lazyOutput;

    public FieldExtractExec(Source source, PhysicalPlan child, List<Attribute> attributesToExtract, MappedFieldType.FieldExtractPreference defaultPreference) {
        this(source, child, attributesToExtract, defaultPreference, Set.of(), Set.of());
    }

    protected FieldExtractExec(Source source, PhysicalPlan child, List<Attribute> attributesToExtract, MappedFieldType.FieldExtractPreference defaultPreference, Set<Attribute> docValuesAttributes, Set<Attribute> boundsAttributes) {
        super(source, child);
        this.attributesToExtract = attributesToExtract;
        this.sourceAttribute = FieldExtractExec.extractSourceAttributesFrom(child);
        this.docValuesAttributes = docValuesAttributes;
        this.boundsAttributes = boundsAttributes;
        this.defaultPreference = defaultPreference;
    }

    private FieldExtractExec(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class), in.readNamedWriteableCollectionAsList(Attribute.class), MappedFieldType.FieldExtractPreference.NONE);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteableCollection(this.attributesToExtract());
    }

    public String getWriteableName() {
        return FieldExtractExec.ENTRY.name;
    }

    @Nullable
    public static Attribute extractSourceAttributesFrom(PhysicalPlan plan) {
        for (Attribute attribute : plan.outputSet()) {
            if (!EsQueryExec.isDocAttribute(attribute)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    protected AttributeSet computeReferences() {
        return this.sourceAttribute != null ? AttributeSet.of(this.sourceAttribute) : AttributeSet.EMPTY;
    }

    @Override
    protected NodeInfo<? extends FieldExtractExec> info() {
        return NodeInfo.create(this, FieldExtractExec::new, this.child(), this.attributesToExtract, this.defaultPreference);
    }

    @Override
    public UnaryExec replaceChild(PhysicalPlan newChild) {
        return new FieldExtractExec(this.source(), newChild, this.attributesToExtract, this.defaultPreference, this.docValuesAttributes, this.boundsAttributes);
    }

    public FieldExtractExec withDocValuesAttributes(Set<Attribute> docValuesAttributes) {
        return new FieldExtractExec(this.source(), this.child(), this.attributesToExtract, this.defaultPreference, docValuesAttributes, this.boundsAttributes);
    }

    public FieldExtractExec withBoundsAttributes(Set<Attribute> boundsAttributes) {
        return new FieldExtractExec(this.source(), this.child(), this.attributesToExtract, this.defaultPreference, this.docValuesAttributes, boundsAttributes);
    }

    public FieldExtractExec withAttributesToExtract(List<Attribute> attributesToExtract) {
        return new FieldExtractExec(this.source(), this.child(), attributesToExtract, this.defaultPreference, this.docValuesAttributes, this.boundsAttributes);
    }

    public List<Attribute> attributesToExtract() {
        return this.attributesToExtract;
    }

    @Nullable
    public Attribute sourceAttribute() {
        return this.sourceAttribute;
    }

    public Set<Attribute> docValuesAttributes() {
        return this.docValuesAttributes;
    }

    public Set<Attribute> boundsAttributes() {
        return this.boundsAttributes;
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            List<Attribute> childOutput = this.child().output();
            this.lazyOutput = new ArrayList<Attribute>(childOutput.size() + this.attributesToExtract.size());
            this.lazyOutput.addAll(childOutput);
            this.lazyOutput.addAll(this.attributesToExtract);
        }
        return this.lazyOutput;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(true, this.attributesToExtract);
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attributesToExtract, this.docValuesAttributes, this.boundsAttributes, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldExtractExec other = (FieldExtractExec)obj;
        return Objects.equals(this.attributesToExtract, other.attributesToExtract) && Objects.equals(this.docValuesAttributes, other.docValuesAttributes) && Objects.equals(this.boundsAttributes, other.boundsAttributes) && Objects.equals(this.child(), other.child());
    }

    @Override
    public String nodeString() {
        return Strings.format((String)"%s<%s,%s>", (Object[])new Object[]{this.nodeName() + NodeUtils.limitedToString(this.attributesToExtract), this.docValuesAttributes, this.boundsAttributes});
    }

    public MappedFieldType.FieldExtractPreference fieldExtractPreference(Attribute attr) {
        if (this.boundsAttributes.contains(attr)) {
            return MappedFieldType.FieldExtractPreference.EXTRACT_SPATIAL_BOUNDS;
        }
        if (this.docValuesAttributes.contains(attr)) {
            return MappedFieldType.FieldExtractPreference.DOC_VALUES;
        }
        return this.defaultPreference;
    }
}

