/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class EsQueryExec
extends LeafExec
implements EstimatesRowSize {
    public static final EsField DOC_ID_FIELD = new EsField("_doc", DataType.DOC_DATA_TYPE, Map.of(), false, EsField.TimeSeriesFieldType.NONE);
    public static final List<EsField> TIME_SERIES_SOURCE_FIELDS = List.of(new EsField("_ts_slice_index", DataType.INTEGER, Map.of(), false, EsField.TimeSeriesFieldType.NONE), new EsField("_ts_future_max_timestamp", DataType.LONG, Map.of(), false, EsField.TimeSeriesFieldType.NONE));
    private final String indexPattern;
    private final IndexMode indexMode;
    private final List<Attribute> attrs;
    private final Expression limit;
    private final List<Sort> sorts;
    private final Integer estimatedRowSize;
    private final List<QueryBuilderAndTags> queryBuilderAndTags;

    public EsQueryExec(Source source, String indexPattern, IndexMode indexMode, List<Attribute> attrs, Expression limit, List<Sort> sorts, Integer estimatedRowSize, List<QueryBuilderAndTags> queryBuilderAndTags) {
        super(source);
        this.indexPattern = indexPattern;
        this.indexMode = indexMode;
        this.attrs = attrs;
        this.limit = limit;
        this.sorts = sorts;
        this.estimatedRowSize = estimatedRowSize;
        this.queryBuilderAndTags = queryBuilderAndTags;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    public static boolean isDocAttribute(Attribute attr) {
        return attr.typeResolved().resolved() && attr.dataType() == DataType.DOC_DATA_TYPE;
    }

    public boolean hasScoring() {
        for (Attribute a : this.attrs()) {
            if (!(a instanceof MetadataAttribute) || !a.name().equals("_score")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected NodeInfo<EsQueryExec> info() {
        return NodeInfo.create(this, EsQueryExec::new, this.indexPattern, this.indexMode, this.attrs, this.limit, this.sorts, this.estimatedRowSize, this.queryBuilderAndTags);
    }

    public String indexPattern() {
        return this.indexPattern;
    }

    public IndexMode indexMode() {
        return this.indexMode;
    }

    public QueryBuilder query() {
        return this.queryWithoutTag();
    }

    @Override
    public List<Attribute> output() {
        return this.attrs;
    }

    public Expression limit() {
        return this.limit;
    }

    public List<Sort> sorts() {
        return this.sorts;
    }

    public List<Attribute> attrs() {
        return this.attrs;
    }

    public Integer estimatedRowSize() {
        return this.estimatedRowSize;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        int size;
        if (this.sorts == null || this.sorts.isEmpty()) {
            state.add(false, 4);
            size = state.consumeAllFields(false);
        } else {
            state.add(false, 8);
            size = state.consumeAllFields(true);
        }
        return Objects.equals(this.estimatedRowSize, size) ? this : new EsQueryExec(this.source(), this.indexPattern, this.indexMode, this.attrs, this.limit, this.sorts, size, this.queryBuilderAndTags);
    }

    public EsQueryExec withLimit(Expression limit) {
        return Objects.equals(this.limit, limit) ? this : new EsQueryExec(this.source(), this.indexPattern, this.indexMode, this.attrs, limit, this.sorts, this.estimatedRowSize, this.queryBuilderAndTags);
    }

    public boolean canPushSorts() {
        return this.indexMode != IndexMode.TIME_SERIES;
    }

    public EsQueryExec withSorts(List<Sort> sorts) {
        if (this.indexMode == IndexMode.TIME_SERIES) {
            assert (false) : "time-series index mode doesn't support sorts";
            throw new UnsupportedOperationException("time-series index mode doesn't support sorts");
        }
        return Objects.equals(this.sorts, sorts) ? this : new EsQueryExec(this.source(), this.indexPattern, this.indexMode, this.attrs, this.limit, sorts, this.estimatedRowSize, this.queryBuilderAndTags);
    }

    public EsQueryExec withQuery(QueryBuilder query) {
        QueryBuilder thisQuery = this.queryWithoutTag();
        return Objects.equals(thisQuery, query) ? this : new EsQueryExec(this.source(), this.indexPattern, this.indexMode, this.attrs, this.limit, this.sorts, this.estimatedRowSize, List.of(new QueryBuilderAndTags(query, List.of())));
    }

    public List<QueryBuilderAndTags> queryBuilderAndTags() {
        return this.queryBuilderAndTags;
    }

    public boolean canSubstituteRoundToWithQueryBuilderAndTags() {
        return this.sorts == null || this.sorts.isEmpty();
    }

    private QueryBuilder queryWithoutTag() {
        QueryBuilderAndTags firstQuery;
        if (this.queryBuilderAndTags == null || this.queryBuilderAndTags.isEmpty()) {
            return null;
        }
        if (this.queryBuilderAndTags.size() == 1) {
            firstQuery = this.queryBuilderAndTags.get(0);
            if (!firstQuery.tags().isEmpty()) {
                throw new UnsupportedOperationException("query is converted to query with tags: [" + String.valueOf(firstQuery) + "]");
            }
        } else {
            throw new UnsupportedOperationException("query is converted to multiple queries and tags: [" + String.valueOf(this.queryBuilderAndTags) + "]");
        }
        QueryBuilder queryWithoutTag = firstQuery.query();
        return queryWithoutTag;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.indexPattern, this.indexMode, this.attrs, this.limit, this.sorts, this.queryBuilderAndTags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EsQueryExec other = (EsQueryExec)obj;
        return Objects.equals(this.indexPattern, other.indexPattern) && Objects.equals(this.indexMode, other.indexMode) && Objects.equals(this.attrs, other.attrs) && Objects.equals(this.limit, other.limit) && Objects.equals(this.sorts, other.sorts) && Objects.equals(this.estimatedRowSize, other.estimatedRowSize) && Objects.equals(this.queryBuilderAndTags, other.queryBuilderAndTags);
    }

    @Override
    public String nodeString() {
        return this.nodeName() + "[" + this.indexPattern + "], indexMode[" + String.valueOf(this.indexMode) + "], " + NodeUtils.limitedToString(this.attrs) + ", limit[" + (this.limit != null ? this.limit.toString() : "") + "], sort[" + (this.sorts != null ? this.sorts.toString() : "") + "] estimatedRowSize[" + this.estimatedRowSize + "] queryBuilderAndTags [" + (this.queryBuilderAndTags != null ? this.queryBuilderAndTags.toString() : "") + "]";
    }

    public record QueryBuilderAndTags(QueryBuilder query, List<Object> tags) {
        public QueryBuilderAndTags withQuery(QueryBuilder query) {
            return new QueryBuilderAndTags(query, this.tags);
        }
    }

    public static enum Missing {
        FIRST("_first"),
        LAST("_last"),
        ANY(null);

        private final String searchOrder;

        private Missing(String searchOrder) {
            this.searchOrder = searchOrder;
        }

        public static Missing from(Order.NullsPosition pos) {
            return switch (pos) {
                case Order.NullsPosition.FIRST -> FIRST;
                case Order.NullsPosition.LAST -> LAST;
                default -> ANY;
            };
        }

        public String searchOrder() {
            return this.searchOrder;
        }
    }

    public static enum Direction {
        ASC,
        DESC;


        public static Direction from(Order.OrderDirection dir) {
            return dir == null || dir == Order.OrderDirection.ASC ? ASC : DESC;
        }

        public SortOrder asOrder() {
            return this == ASC ? SortOrder.ASC : SortOrder.DESC;
        }
    }

    public record ScoreSort(Order.OrderDirection direction) implements Sort
    {
        @Override
        public SortBuilder<?> sortBuilder() {
            return new ScoreSortBuilder();
        }

        @Override
        public FieldAttribute field() {
            return null;
        }

        @Override
        public DataType resulType() {
            return DataType.DOUBLE;
        }
    }

    public record GeoDistanceSort(FieldAttribute field, Order.OrderDirection direction, double lat, double lon) implements Sort
    {
        @Override
        public SortBuilder<?> sortBuilder() {
            GeoDistanceSortBuilder builder = new GeoDistanceSortBuilder(this.field.name(), this.lat, this.lon);
            builder.order(Direction.from(this.direction).asOrder());
            return builder;
        }

        @Override
        public DataType resulType() {
            return DataType.DOUBLE;
        }
    }

    public record FieldSort(FieldAttribute field, Order.OrderDirection direction, Order.NullsPosition nulls) implements Sort
    {
        @Override
        public SortBuilder<?> sortBuilder() {
            FieldSortBuilder builder = new FieldSortBuilder(this.field.name());
            builder.order(Direction.from(this.direction).asOrder());
            builder.missing((Object)Missing.from(this.nulls).searchOrder());
            builder.unmappedType(this.field.dataType().esType());
            return builder;
        }

        @Override
        public DataType resulType() {
            return this.field.dataType();
        }
    }

    public static interface Sort {
        public SortBuilder<?> sortBuilder();

        public Order.OrderDirection direction();

        public FieldAttribute field();

        public DataType resulType();
    }
}

