/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.Dissect;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.RegexExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class DissectExec
extends RegexExtractExec {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "DissectExec", DissectExec::new);
    private final Dissect.Parser parser;

    public DissectExec(Source source, PhysicalPlan child, Expression inputExpression, Dissect.Parser parser, List<Attribute> extractedAttributes) {
        super(source, child, inputExpression, extractedAttributes);
        this.parser = parser;
    }

    private DissectExec(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class), (Expression)in.readNamedWriteable(Expression.class), Dissect.Parser.readFrom(in), in.readNamedWriteableCollectionAsList(Attribute.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteable((NamedWriteable)this.inputExpression());
        this.parser().writeTo(out);
        out.writeNamedWriteableCollection(this.extractedFields());
    }

    public String getWriteableName() {
        return DissectExec.ENTRY.name;
    }

    @Override
    public UnaryExec replaceChild(PhysicalPlan newChild) {
        return new DissectExec(this.source(), newChild, this.inputExpression, this.parser, this.extractedFields);
    }

    @Override
    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create(this, DissectExec::new, this.child(), this.inputExpression, this.parser, this.extractedFields);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DissectExec that = (DissectExec)o;
        return Objects.equals(this.parser, that.parser);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parser);
    }

    public Dissect.Parser parser() {
        return this.parser;
    }
}

