/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class ChangePointExec
extends UnaryExec {
    private final Attribute value;
    private final Attribute key;
    private final Attribute targetType;
    private final Attribute targetPvalue;
    private List<Attribute> output;

    public ChangePointExec(Source source, PhysicalPlan child, Attribute value, Attribute key, Attribute targetType, Attribute targetPvalue) {
        super(source, child);
        this.value = value;
        this.key = key;
        this.targetType = targetType;
        this.targetPvalue = targetPvalue;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    @Override
    protected NodeInfo<? extends ChangePointExec> info() {
        return NodeInfo.create(this, ChangePointExec::new, this.child(), this.value, this.key, this.targetType, this.targetPvalue);
    }

    @Override
    public ChangePointExec replaceChild(PhysicalPlan newChild) {
        return new ChangePointExec(this.source(), newChild, this.value, this.key, this.targetType, this.targetPvalue);
    }

    @Override
    protected AttributeSet computeReferences() {
        return this.key.references().combine(this.value.references());
    }

    @Override
    public List<Attribute> output() {
        if (this.output == null) {
            this.output = NamedExpressions.mergeOutputAttributes(List.of(this.targetType, this.targetPvalue), this.child().output());
        }
        return this.output;
    }

    public Attribute value() {
        return this.value;
    }

    public Attribute key() {
        return this.key;
    }

    public Attribute targetType() {
        return this.targetType;
    }

    public Attribute targetPvalue() {
        return this.targetPvalue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value, this.key, this.targetType, this.targetPvalue);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && Objects.equals(this.value, ((ChangePointExec)other).value) && Objects.equals(this.key, ((ChangePointExec)other).key) && Objects.equals(this.targetType, ((ChangePointExec)other).targetType) && Objects.equals(this.targetPvalue, ((ChangePointExec)other).targetPvalue);
    }
}

