/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql.selector;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.promql.PlaceholderRelation;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.Evaluation;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.LabelMatchers;

public abstract class Selector
extends UnaryPlan {
    private final Expression series;
    private final List<Expression> labels;
    private final LabelMatchers labelMatchers;
    private final Evaluation evaluation;
    protected List<Attribute> output;

    Selector(Source source, Expression series, List<Expression> labels, LabelMatchers labelMatchers, Evaluation evaluation) {
        this(source, PlaceholderRelation.INSTANCE, series, labels, labelMatchers, evaluation);
    }

    Selector(Source source, LogicalPlan child, Expression series, List<Expression> labels, LabelMatchers labelMatchers, Evaluation evaluation) {
        super(source, child);
        this.series = series;
        this.labels = labels;
        this.labelMatchers = labelMatchers;
        this.evaluation = evaluation;
    }

    public Expression series() {
        return this.series;
    }

    public List<Expression> labels() {
        return this.labels;
    }

    public LabelMatchers labelMatchers() {
        return this.labelMatchers;
    }

    public Evaluation evaluation() {
        return this.evaluation;
    }

    @Override
    public boolean expressionsResolved() {
        return this.series.resolved() && Resolvables.resolved(this.labels);
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            Selector selector = (Selector)o;
            return Objects.equals(this.evaluation, selector.evaluation) && Objects.equals(this.labelMatchers, selector.labelMatchers) && Objects.equals(this.series, selector.series) && Objects.equals(this.labels, selector.labels);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.series, this.labels, this.labelMatchers, this.evaluation);
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("should not serialize");
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("should not serialize");
    }
}

