/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql.selector;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.promql.PlaceholderRelation;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.Evaluation;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.LabelMatchers;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.Selector;

public class RangeSelector
extends Selector {
    private final Expression range;

    public RangeSelector(Source source, Expression series, List<Expression> labels, LabelMatchers labelMatchers, Expression range, Evaluation evaluation) {
        this(source, PlaceholderRelation.INSTANCE, series, labels, labelMatchers, range, evaluation);
    }

    public RangeSelector(Source source, LogicalPlan child, Expression series, List<Expression> labels, LabelMatchers labelMatchers, Expression range, Evaluation evaluation) {
        super(source, child, series, labels, labelMatchers, evaluation);
        this.range = range;
    }

    public Expression range() {
        return this.range;
    }

    @Override
    protected NodeInfo<RangeSelector> info() {
        return NodeInfo.create(this, RangeSelector::new, this.child(), this.series(), this.labels(), this.labelMatchers(), this.range, this.evaluation());
    }

    @Override
    public RangeSelector replaceChild(LogicalPlan newChild) {
        return new RangeSelector(this.source(), newChild, this.series(), this.labels(), this.labelMatchers(), this.range, this.evaluation());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RangeSelector that = (RangeSelector)o;
        return Objects.equals(this.range, that.range);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.range);
    }
}

