/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql.selector;

import java.util.Objects;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.lucene.util.automaton.MinimizationOperations;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;

public class LabelMatcher {
    public static final String NAME = "__name__";
    private final String name;
    private final String value;
    private final Matcher matcher;
    private Automaton automaton;

    public LabelMatcher(String name, String value, Matcher matcher) {
        this.name = name;
        this.value = value;
        this.matcher = matcher;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public Matcher matcher() {
        return this.matcher;
    }

    public Automaton automaton() {
        if (this.automaton == null) {
            this.automaton = LabelMatcher.automaton(this.value, this.matcher);
        }
        return this.automaton;
    }

    private static Automaton automaton(String value, Matcher matcher) {
        Automaton automaton;
        try {
            automaton = matcher.isRegex ? new RegExp(value).toAutomaton() : Automata.makeString((String)value);
            automaton = MinimizationOperations.minimize((Automaton)automaton, (int)10000);
        }
        catch (IllegalArgumentException ex) {
            throw new QlIllegalArgumentException((Throwable)ex, "Cannot parse regex {}", new Object[]{value});
        }
        if (matcher == Matcher.NEQ || matcher == Matcher.NREG) {
            automaton = Operations.complement((Automaton)automaton, (int)10000);
        }
        return automaton;
    }

    public boolean matchesAll() {
        return Operations.isTotal((Automaton)this.automaton());
    }

    public boolean matchesNone() {
        return Operations.isEmpty((Automaton)this.automaton());
    }

    public boolean matchesEmpty() {
        return Operations.run((Automaton)this.automaton(), (String)"");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelMatcher label = (LabelMatcher)o;
        return this.matcher == label.matcher && Objects.equals(this.name, label.name) && Objects.equals(this.value, label.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.value, this.matcher});
    }

    public String toString() {
        return this.name + this.matcher.value + this.value;
    }

    public static enum Matcher {
        EQ("=", false),
        NEQ("!=", false),
        REG("=~", true),
        NREG("!~", true);

        private final String value;
        private final boolean isRegex;

        public static Matcher from(String value) {
            switch (value) {
                case "=": {
                    return EQ;
                }
                case "!=": {
                    return NEQ;
                }
                case "=~": {
                    return REG;
                }
                case "!~": {
                    return NREG;
                }
            }
            return null;
        }

        private Matcher(String value, boolean isRegex) {
            this.value = value;
            this.isRegex = isRegex;
        }

        public boolean isRegex() {
            return this.isRegex;
        }
    }
}

