/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.local;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.local.EmptyLocalSupplier;
import org.elasticsearch.xpack.esql.plan.logical.local.ImmediateLocalSupplier;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;

public class LocalRelation
extends LeafPlan {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "LocalRelation", LocalRelation::new);
    private static final TransportVersion ESQL_LOCAL_RELATION_WITH_NEW_BLOCKS = TransportVersion.fromName((String)"esql_local_relation_with_new_blocks");
    private final List<Attribute> output;
    private final LocalSupplier supplier;

    public LocalRelation(Source source, List<Attribute> output, LocalSupplier supplier) {
        super(source);
        this.output = output;
        this.supplier = supplier;
    }

    public LocalRelation(StreamInput in) throws IOException {
        super(Source.readFrom((PlanStreamInput)in));
        this.output = in.readNamedWriteableCollectionAsList(Attribute.class);
        this.supplier = in.getTransportVersion().supports(ESQL_LOCAL_RELATION_WITH_NEW_BLOCKS) ? (LocalSupplier)in.readNamedWriteable(LocalSupplier.class) : LocalSourceExec.readLegacyLocalSupplierFrom((PlanStreamInput)in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteableCollection(this.output);
        if (out.getTransportVersion().supports(ESQL_LOCAL_RELATION_WITH_NEW_BLOCKS)) {
            out.writeNamedWriteable((NamedWriteable)this.supplier);
        } else if (this.hasEmptySupplier()) {
            out.writeVInt(0);
        } else {
            ((ImmediateLocalSupplier)this.supplier).writeTo(out);
        }
    }

    public String getWriteableName() {
        return LocalRelation.ENTRY.name;
    }

    @Override
    protected NodeInfo<LocalRelation> info() {
        return NodeInfo.create(this, LocalRelation::new, this.output, this.supplier);
    }

    public LocalSupplier supplier() {
        return this.supplier;
    }

    public boolean hasEmptySupplier() {
        return this.supplier == EmptyLocalSupplier.EMPTY;
    }

    @Override
    public boolean expressionsResolved() {
        return true;
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.output, this.supplier);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocalRelation other = (LocalRelation)obj;
        return Objects.equals(this.supplier, other.supplier) && Objects.equals(this.output, other.output);
    }
}

