/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.local;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.UnsupportedAttribute;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;

public class EsqlProject
extends Project {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "EsqlProject", EsqlProject::new);

    public EsqlProject(Source source, LogicalPlan child, List<? extends NamedExpression> projections) {
        super(source, child, projections);
    }

    public EsqlProject(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), in.readNamedWriteableCollectionAsList(NamedExpression.class));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteableCollection(this.projections());
    }

    @Override
    public String getWriteableName() {
        return EsqlProject.ENTRY.name;
    }

    @Override
    protected NodeInfo<Project> info() {
        return NodeInfo.create(this, EsqlProject::new, this.child(), this.projections());
    }

    @Override
    public EsqlProject replaceChild(LogicalPlan newChild) {
        return new EsqlProject(this.source(), newChild, this.projections());
    }

    @Override
    public boolean expressionsResolved() {
        for (NamedExpression namedExpression : this.projections()) {
            if (namedExpression.resolved() || namedExpression instanceof UnsupportedAttribute) continue;
            return false;
        }
        return true;
    }

    @Override
    public Project withProjections(List<? extends NamedExpression> projections) {
        return new EsqlProject(this.source(), this.child(), projections);
    }
}

