/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.inference;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.GeneratingPlan;
import org.elasticsearch.xpack.esql.plan.logical.ExecutesOn;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SortAgnostic;
import org.elasticsearch.xpack.esql.plan.logical.SortPreserving;
import org.elasticsearch.xpack.esql.plan.logical.Streaming;
import org.elasticsearch.xpack.esql.plan.logical.SurrogateLogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public abstract class InferencePlan<PlanType extends InferencePlan<PlanType>>
extends UnaryPlan
implements Streaming,
SortAgnostic,
SortPreserving,
GeneratingPlan<InferencePlan<PlanType>>,
ExecutesOn.Coordinator,
SurrogateLogicalPlan {
    protected static final TransportVersion ESQL_INFERENCE_ROW_LIMIT = TransportVersion.fromName((String)"esql_inference_row_limit");
    public static final String INFERENCE_ID_OPTION_NAME = "inference_id";
    public static final List<String> VALID_INFERENCE_OPTION_NAMES = List.of("inference_id");
    private final Expression inferenceId;
    private final Expression rowLimit;

    protected InferencePlan(Source source, LogicalPlan child, Expression inferenceId, Expression rowLimit) {
        super(source, child);
        this.inferenceId = inferenceId;
        this.rowLimit = rowLimit;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteable((NamedWriteable)this.inferenceId());
        if (out.getTransportVersion().supports(ESQL_INFERENCE_ROW_LIMIT)) {
            out.writeNamedWriteable((NamedWriteable)this.rowLimit());
        }
    }

    public Expression inferenceId() {
        return this.inferenceId;
    }

    public Expression rowLimit() {
        return this.rowLimit;
    }

    @Override
    public boolean expressionsResolved() {
        return this.inferenceId.resolved() && this.rowLimit.resolved();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InferencePlan other = (InferencePlan)o;
        return Objects.equals(this.inferenceId(), other.inferenceId()) && Objects.equals(this.rowLimit(), other.rowLimit());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inferenceId(), this.rowLimit());
    }

    @Override
    public LogicalPlan surrogate() {
        return this.replaceChild(new Limit(Source.EMPTY, this.rowLimit(), this.child()));
    }

    public abstract TaskType taskType();

    public abstract PlanType withInferenceId(Expression var1);

    public PlanType withInferenceResolutionError(String inferenceId, String error) {
        return this.withInferenceId(new UnresolvedAttribute(this.inferenceId().source(), inferenceId, error));
    }

    public List<String> validOptionNames() {
        return VALID_INFERENCE_OPTION_NAMES;
    }

    public abstract boolean isFoldable();
}

