/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.plan.GeneratingPlan;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SortAgnostic;
import org.elasticsearch.xpack.esql.plan.logical.SortPreserving;
import org.elasticsearch.xpack.esql.plan.logical.Streaming;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public abstract class RegexExtract
extends UnaryPlan
implements GeneratingPlan<RegexExtract>,
PostAnalysisVerificationAware,
Streaming,
SortAgnostic,
SortPreserving {
    protected final Expression input;
    protected final List<Attribute> extractedFields;

    protected RegexExtract(Source source, LogicalPlan child, Expression input, List<Attribute> extracted) {
        super(source, child);
        this.input = input;
        this.extractedFields = extracted;
    }

    @Override
    public boolean expressionsResolved() {
        return this.input.resolved();
    }

    @Override
    public List<Attribute> output() {
        return NamedExpressions.mergeOutputAttributes(this.extractedFields, this.child().output());
    }

    @Override
    protected AttributeSet computeReferences() {
        return this.input.references();
    }

    public Expression input() {
        return this.input;
    }

    public List<Attribute> extractedFields() {
        return this.extractedFields;
    }

    @Override
    public List<Attribute> generatedAttributes() {
        return this.extractedFields;
    }

    List<Attribute> renameExtractedFields(List<String> newNames) {
        this.checkNumberOfNewNames(newNames);
        ArrayList<Attribute> renamedExtractedFields = new ArrayList<Attribute>(this.extractedFields.size());
        for (int i = 0; i < newNames.size(); ++i) {
            Attribute extractedField = this.extractedFields.get(i);
            String newName = newNames.get(i);
            if (extractedField.name().equals(newName)) {
                renamedExtractedFields.add(extractedField);
                continue;
            }
            renamedExtractedFields.add(this.extractedFields.get(i).withName(newNames.get(i)).withId(new NameId()));
        }
        return renamedExtractedFields;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegexExtract that = (RegexExtract)o;
        return Objects.equals(this.input, that.input) && Objects.equals(this.extractedFields, that.extractedFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.input, this.extractedFields);
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        DataType type = this.input.dataType();
        if (!DataType.isString(type)) {
            failures.add(Failure.fail(this.input, "{} only supports KEYWORD or TEXT values, found expression [{}] type [{}]", new Object[]{this.getClass().getSimpleName(), this.input.sourceText(), type}));
        }
    }
}

