/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationPlanVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.PipelineBreaker;
import org.elasticsearch.xpack.esql.plan.logical.SortAgnostic;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.InlineJoin;

public class OrderBy
extends UnaryPlan
implements PostAnalysisVerificationAware,
PostOptimizationPlanVerificationAware,
TelemetryAware,
SortAgnostic,
PipelineBreaker {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "OrderBy", OrderBy::new);
    private final List<Order> order;

    public OrderBy(Source source, LogicalPlan child, List<Order> order) {
        super(source, child);
        this.order = order;
    }

    private OrderBy(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), in.readCollectionAsList(Order::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeCollection(this.order());
    }

    public String getWriteableName() {
        return OrderBy.ENTRY.name;
    }

    @Override
    protected NodeInfo<OrderBy> info() {
        return NodeInfo.create(this, OrderBy::new, this.child(), this.order);
    }

    @Override
    public OrderBy replaceChild(LogicalPlan newChild) {
        return new OrderBy(this.source(), newChild, this.order);
    }

    public List<Order> order() {
        return this.order;
    }

    @Override
    public String telemetryLabel() {
        return "SORT";
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.order);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.order, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OrderBy other = (OrderBy)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.child(), other.child());
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        this.order.forEach(order -> {
            if (!DataType.isSortable(order.dataType())) {
                failures.add(Failure.fail(order, "cannot sort on " + order.dataType().typeName(), new Object[0]));
            }
        });
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postOptimizationPlanVerification() {
        return (p, failures) -> {
            if (p instanceof InlineJoin) {
                InlineJoin inlineJoin = (InlineJoin)p;
                inlineJoin.left().forEachUp(OrderBy.class, orderBy -> failures.add(Failure.fail(inlineJoin, "INLINE STATS [{}] cannot yet have an unbounded SORT [{}] before it : either move the SORT after it, or add a LIMIT before the SORT", inlineJoin.sourceText(), orderBy.sourceText())));
            } else if (p instanceof OrderBy) {
                failures.add(Failure.fail(p, "Unbounded SORT not supported yet [{}] please add a LIMIT", p.sourceText()));
            }
        };
    }
}

