/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SortAgnostic;
import org.elasticsearch.xpack.esql.plan.logical.SortPreserving;
import org.elasticsearch.xpack.esql.plan.logical.SurrogateLogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.InlineJoin;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;

public class InlineStats
extends UnaryPlan
implements NamedWriteable,
SurrogateLogicalPlan,
TelemetryAware,
SortAgnostic,
SortPreserving,
PostAnalysisPlanVerificationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "InlineStats", InlineStats::new);
    private final Aggregate aggregate;
    private List<Attribute> lazyOutput;

    public InlineStats(Source source, Aggregate aggregate) {
        super(source, aggregate);
        this.aggregate = aggregate;
    }

    public InlineStats(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Aggregate)in.readNamedWriteable(LogicalPlan.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.aggregate);
    }

    public String getWriteableName() {
        return InlineStats.ENTRY.name;
    }

    @Override
    protected NodeInfo<InlineStats> info() {
        return NodeInfo.create(this, InlineStats::new, this.aggregate);
    }

    @Override
    public InlineStats replaceChild(LogicalPlan newChild) {
        return new InlineStats(this.source(), (Aggregate)newChild);
    }

    public Aggregate aggregate() {
        return this.aggregate;
    }

    @Override
    public boolean expressionsResolved() {
        return this.aggregate.expressionsResolved();
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = NamedExpressions.mergeOutputAttributes(this.aggregate.output(), this.aggregate.child().output());
        }
        return this.lazyOutput;
    }

    private JoinConfig joinConfig() {
        List<Expression> groupings = this.aggregate.groupings();
        List<Object> namedGroupings = new ArrayList(groupings.size());
        for (Expression g : groupings) {
            namedGroupings.add(Expressions.attribute(g));
        }
        namedGroupings = NamedExpressions.mergeOutputAttributes(namedGroupings, Collections.emptyList());
        ArrayList<Attribute> leftFields = new ArrayList<Attribute>(groupings.size());
        ArrayList<Attribute> rightFields = new ArrayList<Attribute>(groupings.size());
        List<Attribute> rhsOutput = Join.makeReference(this.aggregate.output());
        block1: for (Attribute attribute : namedGroupings) {
            for (Attribute rhs : rhsOutput) {
                if (!attribute.name().equals(rhs.name())) continue;
                leftFields.add(attribute);
                rightFields.add(rhs);
                continue block1;
            }
        }
        return new JoinConfig(JoinTypes.LEFT, leftFields, rightFields, null);
    }

    @Override
    public LogicalPlan surrogate() {
        Source source = this.source();
        LogicalPlan left = this.aggregate.child();
        return new InlineJoin(source, left, InlineJoin.stubSource(this.aggregate, left), this.joinConfig());
    }

    @Override
    public String telemetryLabel() {
        return "INLINE STATS";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aggregate, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InlineStats other = (InlineStats)obj;
        return Objects.equals(this.aggregate, other.aggregate);
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return (p, failures) -> {
            if (p instanceof InlineStats) {
                InlineStats inlineStats = (InlineStats)p;
                Holder foundInlineStats = new Holder((Object)false);
                Holder foundPreviousStats = new Holder((Object)false);
                Holder isTimeSeries = new Holder((Object)false);
                inlineStats.child().forEachUp(lp -> {
                    EsRelation er;
                    if (lp instanceof Aggregate) {
                        if (!((Boolean)foundInlineStats.get()).booleanValue()) {
                            foundInlineStats.set((Object)true);
                        } else {
                            foundPreviousStats.set((Object)true);
                        }
                    } else if (lp instanceof EsRelation && (er = (EsRelation)lp).indexMode() == IndexMode.TIME_SERIES) {
                        isTimeSeries.set((Object)true);
                    }
                });
                if (((Boolean)isTimeSeries.get()).booleanValue() && !((Boolean)foundPreviousStats.get()).booleanValue()) {
                    failures.add(Failure.fail(inlineStats, "INLINE STATS [{}] can only be used after STATS when used with TS command", this.sourceText()));
                }
            }
        };
    }
}

