/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public abstract class BinaryPlan
extends LogicalPlan {
    private final LogicalPlan left;
    private final LogicalPlan right;

    protected BinaryPlan(Source source, LogicalPlan left, LogicalPlan right) {
        super(source, Arrays.asList(left, right));
        this.left = left;
        this.right = right;
    }

    public LogicalPlan left() {
        return this.left;
    }

    public LogicalPlan right() {
        return this.right;
    }

    public AttributeSet leftReferences() {
        return this.left.references();
    }

    public AttributeSet rightReferences() {
        return this.right.references();
    }

    @Override
    public final BinaryPlan replaceChildren(List<LogicalPlan> newChildren) {
        return this.replaceChildren(newChildren.get(0), newChildren.get(1));
    }

    public final BinaryPlan replaceLeft(LogicalPlan newLeft) {
        return this.replaceChildren(newLeft, this.right);
    }

    public final BinaryPlan replaceRight(LogicalPlan newRight) {
        return this.replaceChildren(this.left, newRight);
    }

    public abstract BinaryPlan replaceChildren(LogicalPlan var1, LogicalPlan var2);

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryPlan other = (BinaryPlan)obj;
        return Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

