/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser.promql;

import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.esql.core.tree.Location;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.parser.ParsingException;

public class PromqlParserUtils {
    private static final Map<String, Long> TIME_UNITS;

    private PromqlParserUtils() {
    }

    public static Duration parseDuration(Source source, String string) {
        char[] chars = string.toCharArray();
        long millis = 0L;
        String errorPrefix = "Invalid time duration [{}], ";
        Tuple lastUnit = null;
        int i = 0;
        while (i < chars.length) {
            int number;
            int current;
            for (current = i; current < chars.length && Character.isDigit(chars[current]); ++current) {
            }
            if (current == i) {
                throw new ParsingException(source, errorPrefix + "no number specified at index [{}]", string, current);
            }
            String token = new String(chars, i, current - i);
            try {
                number = Integer.parseInt(token);
            }
            catch (NumberFormatException ex) {
                throw new ParsingException(source, errorPrefix + "invalid number [{}]", string, token);
            }
            i = current;
            while (current < chars.length && Character.isLetter(chars[current])) {
                ++current;
            }
            if (current == i) {
                throw new ParsingException(source, errorPrefix + "no unit specified at index [{}]", string, current);
            }
            token = new String(chars, i, current - i);
            i = current;
            Long msMultiplier = TIME_UNITS.get(token);
            if (msMultiplier == null) {
                throw new ParsingException(source, errorPrefix + "unrecognized time unit [{}], must be one of {}", string, token, TIME_UNITS.keySet());
            }
            if (lastUnit != null) {
                if ((Long)lastUnit.v2() < msMultiplier) {
                    throw new ParsingException(source, errorPrefix + "units must be ordered from the longest to the shortest, found [{}] before [{}]", string, lastUnit.v1(), token);
                }
                if (((Long)lastUnit.v2()).equals(msMultiplier)) {
                    throw new ParsingException(source, errorPrefix + "a given unit must only appear once, found [{}] multiple times", string, token);
                }
            }
            lastUnit = new Tuple((Object)token, (Object)msMultiplier);
            millis += (long)number * msMultiplier;
        }
        return Duration.ofMillis(millis);
    }

    static String unquote(Source source) {
        if (source == null) {
            return null;
        }
        String text = source.text();
        boolean unescaped = text.startsWith("`");
        text = text.substring(1, text.length() - 1);
        if (unescaped) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = text.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\\') {
                switch (chars[++i]) {
                    case 'a': {
                        sb.append('\u0007');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'v': {
                        sb.append('\u000b');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case 'U': 
                    case 'u': 
                    case 'x': {
                        char ch = chars[i++];
                        int count = ch == 'U' ? 8 : (ch == 'u' ? 4 : 2);
                        sb.append(PromqlParserUtils.fromRadix(source, chars, i, count, 16));
                        i += count - 1;
                        break;
                    }
                    default: {
                        int count = 3;
                        sb.append(PromqlParserUtils.fromRadix(source, chars, i, count, 8));
                        i += count - 1;
                    }
                }
                ++i;
                continue;
            }
            sb.append(chars[i++]);
        }
        return sb.toString();
    }

    private static String fromRadix(Source source, char[] chars, int offset, int count, int radix) {
        int code;
        if (offset + count > chars.length) {
            throw new ParsingException(source, "Incomplete escape sequence at [{}], expected [{}] found [{}]", offset, count, chars.length - offset - 1);
        }
        String toParse = new String(chars, offset, count);
        try {
            code = Integer.parseInt(toParse, radix);
        }
        catch (NumberFormatException ex) {
            throw new ParsingException(source, "Invalid unicode character code [{}]", toParse);
        }
        if (radix == 16 && count == 2 && code >= 128 && code <= 255) {
            throw new ParsingException(source, "Invalid unicode character code [\\x{}], single-byte UTF-8 characters must be in range 0x00-0x7F", toParse);
        }
        return String.valueOf(Character.toChars(code));
    }

    public static Source adjustSource(Source source, int startLine, int startColumn) {
        return new Source(PromqlParserUtils.adjustLocation(source.source(), startLine, startColumn), source.text());
    }

    public static Location adjustLocation(Location location, int startLine, int startColumn) {
        int lineNumber = location.getLineNumber();
        int columnNumber = location.getColumnNumber();
        return new Location(PromqlParserUtils.adjustLine(lineNumber, startLine), PromqlParserUtils.adjustColumn(lineNumber, columnNumber, startColumn));
    }

    public static ParsingException adjustParsingException(ParsingException pe, int promqlStartLine, int promqlStartColumn) {
        ParsingException adjusted = new ParsingException(pe.getErrorMessage(), pe.getCause() instanceof Exception ? (Exception)pe.getCause() : null, PromqlParserUtils.adjustLine(pe.getLineNumber(), promqlStartLine), PromqlParserUtils.adjustColumn(pe.getLineNumber(), pe.getColumnNumber(), promqlStartColumn));
        adjusted.setStackTrace(pe.getStackTrace());
        return adjusted;
    }

    private static int adjustLine(int lineNumber, int startLine) {
        return lineNumber + startLine - 1;
    }

    private static int adjustColumn(int lineNumber, int columnNumber, int startColumn) {
        return lineNumber == 1 ? columnNumber + startColumn - 1 : columnNumber;
    }

    public static Instant parseDate(Source source, String value) {
        try {
            return Instant.ofEpochMilli((long)(Double.parseDouble(value) * 1000.0));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Instant.parse(value);
            }
            catch (DateTimeParseException e) {
                throw new ParsingException(source, "Invalid date format [{}]", value);
            }
        }
    }

    static {
        LinkedHashMap<String, Long> map = new LinkedHashMap<String, Long>();
        map.put("y", 31536000000L);
        map.put("w", 604800000L);
        map.put("d", 86400000L);
        map.put("h", 3600000L);
        map.put("m", 60000L);
        map.put("s", 1000L);
        map.put("ms", 1L);
        TIME_UNITS = Collections.unmodifiableMap(map);
    }
}

