/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser.promql;

import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.arithmetic.Arithmetics;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.promql.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.promql.function.PromqlFunctionRegistry;
import org.elasticsearch.xpack.esql.expression.promql.subquery.Subquery;
import org.elasticsearch.xpack.esql.parser.ParserUtils;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.parser.PromqlBaseParser;
import org.elasticsearch.xpack.esql.parser.promql.PromqlExpressionBuilder;
import org.elasticsearch.xpack.esql.parser.promql.PromqlFoldingUtils;
import org.elasticsearch.xpack.esql.parser.promql.PromqlParserUtils;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.promql.AcrossSeriesAggregate;
import org.elasticsearch.xpack.esql.plan.logical.promql.PromqlFunctionCall;
import org.elasticsearch.xpack.esql.plan.logical.promql.WithinSeriesAggregate;
import org.elasticsearch.xpack.esql.plan.logical.promql.operator.VectorBinaryOperator;
import org.elasticsearch.xpack.esql.plan.logical.promql.operator.VectorMatch;
import org.elasticsearch.xpack.esql.plan.logical.promql.operator.arithmetic.VectorBinaryArithmetic;
import org.elasticsearch.xpack.esql.plan.logical.promql.operator.comparison.VectorBinaryComparison;
import org.elasticsearch.xpack.esql.plan.logical.promql.operator.set.VectorBinarySet;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.Evaluation;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.InstantSelector;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.LabelMatcher;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.LabelMatchers;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.LiteralSelector;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.RangeSelector;

public class PromqlLogicalPlanBuilder
extends PromqlExpressionBuilder {
    public static final Duration GLOBAL_EVALUATION_INTERVAL = Duration.ofMinutes(1L);

    PromqlLogicalPlanBuilder(Literal start, Literal end, int startLine, int startColumn) {
        super(start, end, startLine, startColumn);
    }

    protected LogicalPlan plan(ParseTree ctx) {
        return this.wrapLiteral(ctx);
    }

    @Override
    public LogicalPlan visitSingleStatement(PromqlBaseParser.SingleStatementContext ctx) {
        return this.plan((ParseTree)ctx.expression());
    }

    static boolean isRangeVector(LogicalPlan plan) {
        LogicalPlan logicalPlan = plan;
        Objects.requireNonNull(logicalPlan);
        LogicalPlan logicalPlan2 = logicalPlan;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RangeSelector.class, Subquery.class}, (Object)logicalPlan2, n)) {
            case 0 -> {
                RangeSelector r = (RangeSelector)logicalPlan2;
                yield true;
            }
            case 1 -> {
                Subquery s = (Subquery)logicalPlan2;
                yield true;
            }
            default -> false;
        };
    }

    static boolean isScalar(LogicalPlan plan) {
        return plan instanceof LiteralSelector;
    }

    private LogicalPlan wrapLiteral(ParseTree ctx) {
        Object result;
        if (ctx == null) {
            return null;
        }
        Source source = this.source(ctx);
        Object object = result = this.visit(ctx);
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LogicalPlan.class, Literal.class, Duration.class, Expression.class}, (Object)object2, n)) {
            case 0 -> {
                LogicalPlan plan;
                yield plan = (LogicalPlan)object2;
            }
            case 1 -> {
                Literal literal = (Literal)object2;
                yield new LiteralSelector(source, literal);
            }
            case 2 -> {
                Duration duration = (Duration)object2;
                yield new LiteralSelector(source, Literal.timeDuration(source, duration));
            }
            case 3 -> {
                Expression expr = (Expression)object2;
                throw new ParsingException(source, "Expected a plan or literal, got expression [{}]", expr.getClass().getSimpleName());
            }
            default -> throw new ParsingException(source, "Expected a plan, got [{}]", result.getClass().getSimpleName());
        };
    }

    private Literal unwrapLiteral(ParserRuleContext ctx) {
        Object o;
        Object object = o = this.visit((ParseTree)ctx);
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Literal.class, Expression.class, LiteralSelector.class}, (Object)object2, n)) {
            case 0 -> {
                Literal literal;
                yield literal = (Literal)object2;
            }
            case 1 -> {
                Expression expression = (Expression)object2;
                if (expression.foldable()) {
                    yield Literal.of(FoldContext.small(), expression);
                }
                throw new ParsingException(this.source(ctx), "Constant expression required, found [{}]", expression.sourceText());
            }
            case 2 -> {
                LiteralSelector selector = (LiteralSelector)object2;
                yield selector.literal();
            }
            default -> throw new ParsingException(this.source(ctx), "Constant expression required, found [{}]", ctx.getText());
        };
    }

    @Override
    public LogicalPlan visitSelector(PromqlBaseParser.SelectorContext ctx) {
        boolean identifierId;
        Source source = this.source(ctx);
        PromqlBaseParser.SeriesMatcherContext seriesMatcher = ctx.seriesMatcher();
        String id = this.visitIdentifier(seriesMatcher.identifier());
        ArrayList<LabelMatcher> labels = new ArrayList<LabelMatcher>();
        UnresolvedAttribute series = null;
        ArrayList<Expression> labelExpressions = new ArrayList<Expression>();
        boolean bl = identifierId = id != null;
        if (id != null) {
            labels.add(new LabelMatcher("__name__", id, LabelMatcher.Matcher.EQ));
            series = new UnresolvedAttribute(this.source(seriesMatcher.identifier()), id);
        }
        boolean nonEmptyMatcher = id != null;
        LinkedHashSet<String> seenLabelNames = new LinkedHashSet<String>();
        PromqlBaseParser.LabelsContext labelsCtx = seriesMatcher.labels();
        if (labelsCtx != null) {
            for (PromqlBaseParser.LabelContext labelCtx : labelsCtx.label()) {
                PromqlBaseParser.LabelNameContext nameCtx = labelCtx.labelName();
                String labelName = this.visitLabelName(nameCtx);
                if (labelName.contains(":")) {
                    throw new ParsingException(this.source(nameCtx), "[:] not allowed in label names [{}]", labelName);
                }
                if (labelCtx.kind == null) {
                    if (identifierId) {
                        throw new ParsingException(this.source(labelCtx), "Metric name must not be defined twice: [{}] or [{}]", id, labelName);
                    }
                    if (id == null) {
                        id = labelName;
                        series = new UnresolvedAttribute(this.source(labelCtx), id);
                    }
                    labels.add(new LabelMatcher("__name__", labelName, LabelMatcher.Matcher.EQ));
                    if (seenLabelNames.add("__name__")) {
                        labelExpressions.add(new UnresolvedAttribute(this.source(nameCtx), "__name__"));
                    }
                    nonEmptyMatcher = true;
                    continue;
                }
                String kind = labelCtx.kind.getText();
                LabelMatcher.Matcher matcher = LabelMatcher.Matcher.from(kind);
                if (matcher == null) {
                    throw new ParsingException(this.source(labelCtx), "Unrecognized label matcher [{}]", kind);
                }
                String labelValue = this.string(labelCtx.STRING());
                Source valueCtx = this.source(labelCtx.STRING());
                if ("__name__".equals(labelName)) {
                    if (identifierId) {
                        throw new ParsingException(this.source(nameCtx), "Metric name must not be defined twice: [{}] or [{}]", id, labelValue);
                    }
                    if (id == null) {
                        id = labelValue;
                        series = new UnresolvedAttribute(valueCtx, id);
                    }
                }
                LabelMatcher label = new LabelMatcher(labelName, labelValue, matcher);
                labels.add(label);
                if (seenLabelNames.add(labelName)) {
                    labelExpressions.add(new UnresolvedAttribute(this.source(nameCtx), labelName));
                }
                if (nonEmptyMatcher || label.matchesEmpty()) continue;
                nonEmptyMatcher = true;
            }
            if (!nonEmptyMatcher) {
                throw new ParsingException(this.source(labelsCtx), "Vector selector must contain at least one non-empty matcher", new Object[0]);
            }
        }
        Evaluation evaluation = this.visitEvaluation(ctx.evaluation());
        Literal range = this.visitDuration(ctx.duration());
        LabelMatchers matchers = new LabelMatchers(labels);
        return range == Literal.NULL ? new InstantSelector(source, series, labelExpressions, matchers, evaluation) : new RangeSelector(source, series, labelExpressions, matchers, range, evaluation);
    }

    @Override
    public LogicalPlan visitArithmeticUnary(PromqlBaseParser.ArithmeticUnaryContext ctx) {
        Source source = this.source(ctx);
        LogicalPlan unary = this.wrapLiteral((ParseTree)ctx.expression());
        if (unary instanceof LiteralSelector) {
            LiteralSelector literalSelector = (LiteralSelector)unary;
            Literal literal = literalSelector.literal();
            Object value = literal.value();
            DataType dataType = literal.dataType();
            if (!dataType.isNumeric() || !(value instanceof Number)) {
                throw new ParsingException(source, "Unary expression only allowed on expressions of type numeric or instant vector, got [{}]", dataType.typeName());
            }
            if (ctx.operator.getType() == 2) {
                Number negatedValue = Arithmetics.negate((Number)value);
                unary = new LiteralSelector(source, new Literal(unary.source(), negatedValue, dataType));
            }
        } else if (PromqlLogicalPlanBuilder.isRangeVector(unary)) {
            throw new ParsingException(source, "Unary expression only allowed on expressions of type numeric or instant vector, got [{}]", unary.nodeName());
        }
        if (ctx.operator.getType() == 2) {
            LiteralSelector zero = new LiteralSelector(source, Literal.integer(source, 0));
            return new VectorBinaryArithmetic(source, zero, unary, VectorMatch.NONE, VectorBinaryArithmetic.ArithmeticOp.SUB);
        }
        return unary;
    }

    @Override
    public LogicalPlan visitArithmeticBinary(PromqlBaseParser.ArithmeticBinaryContext ctx) {
        Source source = this.source(ctx);
        LogicalPlan le = this.wrapLiteral((ParseTree)ctx.left);
        LogicalPlan re = this.wrapLiteral((ParseTree)ctx.right);
        boolean bool = ctx.BOOL() != null;
        int opType = ctx.op.getType();
        String opText = ctx.op.getText();
        boolean leftIsScalar = PromqlLogicalPlanBuilder.isScalar(le);
        boolean rightIsScalar = PromqlLogicalPlanBuilder.isScalar(re);
        if (!bool && leftIsScalar && rightIsScalar) {
            switch (opType) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    throw new ParsingException(source, "Comparisons [{}] between scalars must use the BOOL modifier", opText);
                }
            }
        }
        if (leftIsScalar || rightIsScalar) {
            switch (opType) {
                case 16: 
                case 17: 
                case 18: {
                    throw new ParsingException(source, "Set operator [{}] not allowed in binary scalar expression", opText);
                }
            }
        }
        VectorBinaryOperator.BinaryOp binaryOperator = this.binaryOp(ctx.op);
        if (le instanceof LiteralSelector) {
            LiteralSelector leftSel = (LiteralSelector)le;
            if (re instanceof LiteralSelector) {
                LiteralSelector rightSel = (LiteralSelector)re;
                Literal leftLiteral = leftSel.literal();
                Literal rightLiteral = rightSel.literal();
                Object leftValue = leftLiteral.value();
                Object rightValue = rightLiteral.value();
                if (binaryOperator instanceof VectorBinaryArithmetic.ArithmeticOp) {
                    VectorBinaryArithmetic.ArithmeticOp arithmeticOp = (VectorBinaryArithmetic.ArithmeticOp)binaryOperator;
                    Object result = PromqlFoldingUtils.evaluate(source, leftValue, rightValue, arithmeticOp);
                    DataType resultType = this.determineResultType(result);
                    return new LiteralSelector(source, new Literal(source, result, resultType));
                }
                if (binaryOperator instanceof VectorBinaryComparison.ComparisonOp) {
                    VectorBinaryComparison.ComparisonOp compOp = (VectorBinaryComparison.ComparisonOp)binaryOperator;
                    int result = PromqlFoldingUtils.evaluate(source, leftValue, rightValue, compOp) ? 1 : 0;
                    return new LiteralSelector(source, Literal.integer(source, result));
                }
            }
        }
        VectorMatch modifier = VectorMatch.NONE;
        PromqlBaseParser.ModifierContext modifierCtx = ctx.modifier();
        if (modifierCtx != null) {
            if (PromqlLogicalPlanBuilder.isRangeVector(le) || PromqlLogicalPlanBuilder.isRangeVector(re) || PromqlLogicalPlanBuilder.isScalar(le) || PromqlLogicalPlanBuilder.isScalar(re)) {
                throw new ParsingException(source, "Vector matching allowed only between instant vectors", new Object[0]);
            }
            VectorMatch.Filter filter = modifierCtx.ON() != null ? VectorMatch.Filter.ON : VectorMatch.Filter.IGNORING;
            List filterList = this.visitLabelList(modifierCtx.modifierLabels);
            VectorMatch.Joining joining = VectorMatch.Joining.NONE;
            List groupingList = this.visitLabelList(modifierCtx.groupLabels);
            if (modifierCtx.joining != null) {
                joining = modifierCtx.GROUP_LEFT() != null ? VectorMatch.Joining.LEFT : VectorMatch.Joining.RIGHT;
                switch (opType) {
                    case 16: 
                    case 17: 
                    case 18: {
                        throw new ParsingException(this.source(modifierCtx), "No grouping [{}] allowed for [{}] operator", new Object[]{joining, opText});
                    }
                }
                if (modifierCtx.ON() != null) {
                    ArrayList repeatedLabels = new ArrayList(groupingList);
                    if (!filterList.isEmpty() && repeatedLabels.retainAll(filterList) && !repeatedLabels.isEmpty()) {
                        throw new ParsingException(this.source(modifierCtx.ON()), "Label{} {} must not occur in ON and GROUP clause at once", repeatedLabels.size() > 1 ? "s" : "", repeatedLabels);
                    }
                }
            }
            modifier = new VectorMatch(filter, new LinkedHashSet<String>(filterList), joining, new LinkedHashSet<String>(groupingList));
        }
        VectorBinaryOperator.BinaryOp binaryOp = binaryOperator;
        Objects.requireNonNull(binaryOp);
        VectorBinaryOperator.BinaryOp binaryOp2 = binaryOp;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VectorBinaryArithmetic.ArithmeticOp.class, VectorBinaryComparison.ComparisonOp.class, VectorBinarySet.SetOp.class}, (Object)binaryOp2, n)) {
            case 0 -> {
                VectorBinaryArithmetic.ArithmeticOp arithmeticOp = (VectorBinaryArithmetic.ArithmeticOp)binaryOp2;
                yield new VectorBinaryArithmetic(source, le, re, modifier, arithmeticOp);
            }
            case 1 -> {
                VectorBinaryComparison.ComparisonOp comparisonOp = (VectorBinaryComparison.ComparisonOp)binaryOp2;
                yield new VectorBinaryComparison(source, le, re, modifier, bool, comparisonOp);
            }
            case 2 -> {
                VectorBinarySet.SetOp setOp = (VectorBinarySet.SetOp)binaryOp2;
                yield new VectorBinarySet(source, le, re, modifier, setOp);
            }
            default -> throw new ParsingException(this.source(ctx.op), "Unknown arithmetic {}", opText);
        };
    }

    private VectorBinaryOperator.BinaryOp binaryOp(Token opType) {
        return switch (opType.getType()) {
            case 6 -> VectorBinaryArithmetic.ArithmeticOp.POW;
            case 3 -> VectorBinaryArithmetic.ArithmeticOp.MUL;
            case 5 -> VectorBinaryArithmetic.ArithmeticOp.MOD;
            case 4 -> VectorBinaryArithmetic.ArithmeticOp.DIV;
            case 2 -> VectorBinaryArithmetic.ArithmeticOp.SUB;
            case 1 -> VectorBinaryArithmetic.ArithmeticOp.ADD;
            case 7 -> VectorBinaryComparison.ComparisonOp.EQ;
            case 8 -> VectorBinaryComparison.ComparisonOp.NEQ;
            case 11 -> VectorBinaryComparison.ComparisonOp.LT;
            case 12 -> VectorBinaryComparison.ComparisonOp.LTE;
            case 9 -> VectorBinaryComparison.ComparisonOp.GT;
            case 10 -> VectorBinaryComparison.ComparisonOp.GTE;
            case 16 -> VectorBinarySet.SetOp.INTERSECT;
            case 18 -> VectorBinarySet.SetOp.SUBTRACT;
            case 17 -> VectorBinarySet.SetOp.UNION;
            default -> throw new ParsingException(this.source(opType), "Unknown arithmetic {}", opType.getText());
        };
    }

    private DataType determineResultType(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Duration.class, Integer.class, Long.class, Double.class, Number.class}, (Object)object2, n)) {
            case 0 -> {
                Duration d = (Duration)object2;
                yield DataType.TIME_DURATION;
            }
            case 1 -> {
                Integer i = (Integer)object2;
                yield DataType.INTEGER;
            }
            case 2 -> {
                Long l = (Long)object2;
                yield DataType.LONG;
            }
            case 3 -> {
                Double d = (Double)object2;
                yield DataType.DOUBLE;
            }
            case 4 -> {
                Number n = (Number)object2;
                yield DataType.DOUBLE;
            }
            default -> throw new IllegalArgumentException("Unexpected result type: " + String.valueOf(value.getClass()));
        };
    }

    @Override
    public Object visitParenthesized(PromqlBaseParser.ParenthesizedContext ctx) {
        return this.visit((ParseTree)ctx.expression());
    }

    @Override
    public LogicalPlan visitFunction(PromqlBaseParser.FunctionContext ctx) {
        Source source = this.source(ctx);
        String name = ctx.IDENTIFIER().getText().toLowerCase(Locale.ROOT);
        Boolean exists = PromqlFunctionRegistry.INSTANCE.functionExists(name);
        if (!Boolean.TRUE.equals(exists)) {
            String message = exists == null ? "Function [{}] not implemented yet" : "Unknown function [{}]";
            throw new ParsingException(source, message, name);
        }
        PromqlFunctionRegistry.FunctionDefinition metadata = PromqlFunctionRegistry.INSTANCE.functionMetadata(name);
        PromqlBaseParser.FunctionParamsContext paramsCtx = ctx.functionParams();
        List params = paramsCtx != null ? ParserUtils.visitList(this, paramsCtx.expression(), Node.class) : Collections.emptyList();
        int paramCount = params.size();
        String message = "Invalid number of parameters for function [{}], required [{}], found [{}]";
        if (paramCount < metadata.arity().min()) {
            throw new ParsingException(source, message, name, metadata.arity().min(), paramCount);
        }
        if (paramCount > metadata.arity().max()) {
            throw new ParsingException(source, message, name, metadata.arity().max(), paramCount);
        }
        LogicalPlan child = (LogicalPlan)params.get(0);
        PromqlBaseParser.GroupingContext groupingContext = ctx.grouping();
        PromqlFunctionCall plan = null;
        if (groupingContext != null) {
            AcrossSeriesAggregate.Grouping grouping;
            AcrossSeriesAggregate.Grouping grouping2 = grouping = groupingContext.BY() != null ? AcrossSeriesAggregate.Grouping.BY : AcrossSeriesAggregate.Grouping.WITHOUT;
            if (grouping != AcrossSeriesAggregate.Grouping.BY) {
                throw new ParsingException(source, "[{}] clause not supported yet", grouping.name().toLowerCase(Locale.ROOT), name);
            }
            if (metadata.functionType() != FunctionType.ACROSS_SERIES_AGGREGATION) {
                throw new ParsingException(source, "[{}] clause not allowed on non-aggregation function [{}]", grouping.name().toLowerCase(Locale.ROOT), name);
            }
            PromqlBaseParser.LabelListContext labelListCtx = groupingContext.labelList();
            List groupingKeys = this.visitLabelList(labelListCtx);
            ArrayList<NamedExpression> groupings = new ArrayList<NamedExpression>(groupingKeys.size());
            for (int i = 0; i < groupingKeys.size(); ++i) {
                groupings.add(new UnresolvedAttribute(this.source(labelListCtx.labelName(i)), (String)groupingKeys.get(i)));
            }
            plan = new AcrossSeriesAggregate(source, child, name, List.of(), grouping, groupings);
        } else if (metadata.functionType() == FunctionType.ACROSS_SERIES_AGGREGATION) {
            plan = new AcrossSeriesAggregate(source, child, name, List.of(), AcrossSeriesAggregate.Grouping.NONE, List.of());
        } else if (metadata.functionType() == FunctionType.WITHIN_SERIES_AGGREGATION) {
            if (!PromqlLogicalPlanBuilder.isRangeVector(child)) {
                throw new ParsingException(source, "expected type range vector in call to function [{}], got instant vector", name);
            }
            plan = new WithinSeriesAggregate(source, child, name, List.of());
        }
        return plan;
    }

    @Override
    public Subquery visitSubquery(PromqlBaseParser.SubqueryContext ctx) {
        Source source = this.source(ctx);
        LogicalPlan plan = this.plan((ParseTree)ctx.expression());
        if (PromqlLogicalPlanBuilder.isRangeVector(plan)) {
            throw new ParsingException(source, "Subquery is only allowed on instant vector, got {}", plan.nodeName());
        }
        Evaluation evaluation = this.visitEvaluation(ctx.evaluation());
        Literal rangeEx = this.visitDuration(ctx.range);
        Literal resolution = this.visitSubqueryResolution(ctx.subqueryResolution());
        if (resolution == null) {
            resolution = Literal.timeDuration(Source.EMPTY, GLOBAL_EVALUATION_INTERVAL);
        }
        return new Subquery(this.source(ctx), plan, rangeEx, resolution, evaluation);
    }

    @Override
    public Literal visitSubqueryResolution(PromqlBaseParser.SubqueryResolutionContext ctx) {
        if (ctx == null) {
            return Literal.NULL;
        }
        if (ctx.resolution != null) {
            return this.visitDuration(ctx.resolution);
        }
        TerminalNode timeCtx = ctx.TIME_VALUE_WITH_COLON();
        if (timeCtx != null) {
            String timeString = timeCtx.getText().substring(1).trim();
            Source timeSource = this.source(timeCtx);
            Duration baseValue = PromqlParserUtils.parseDuration(timeSource, timeString);
            if (ctx.op == null || ctx.expression() == null) {
                return Literal.timeDuration(this.source(timeCtx), baseValue);
            }
            Object rightValue = this.unwrapLiteral(ctx.expression()).value();
            VectorBinaryOperator.BinaryOp binaryOp = this.binaryOp(ctx.op);
            if (!(binaryOp instanceof VectorBinaryArithmetic.ArithmeticOp)) {
                throw new ParsingException(this.source(ctx), "Unsupported binary operator [{}] in time duration", binaryOp);
            }
            VectorBinaryArithmetic.ArithmeticOp operation = (VectorBinaryArithmetic.ArithmeticOp)binaryOp;
            Object result = PromqlFoldingUtils.evaluate(this.source(ctx), (Object)baseValue, rightValue, operation);
            if (result instanceof Duration) {
                Duration duration = (Duration)result;
                return Literal.timeDuration(this.source(timeCtx), duration);
            }
            throw new ParsingException(this.source(ctx), "Expected duration result, got [{}]", result.getClass().getSimpleName());
        }
        return Literal.NULL;
    }
}

