/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser.promql;

import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.StringUtils;
import org.elasticsearch.xpack.esql.parser.ParserUtils;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.parser.PromqlBaseParser;
import org.elasticsearch.xpack.esql.parser.promql.PromqlIdentifierBuilder;
import org.elasticsearch.xpack.esql.parser.promql.PromqlParserUtils;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.Evaluation;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.LiteralSelector;

class PromqlExpressionBuilder
extends PromqlIdentifierBuilder {
    private static final long MAX_DURATION_SECONDS = 9223372036L;
    private static final long MIN_DURATION_SECONDS = -9223372037L;
    private final Literal start;
    private final Literal end;

    PromqlExpressionBuilder(Literal start, Literal end, int startLine, int startColumn) {
        super(startLine, startColumn);
        this.start = start;
        this.end = end;
    }

    protected Expression expression(ParseTree ctx) {
        return ParserUtils.typedParsing(this, ctx, Expression.class);
    }

    protected List<Expression> expressions(List<? extends ParserRuleContext> contexts) {
        return ParserUtils.visitList(this, contexts, Expression.class);
    }

    private static void validateDurationRange(Source source, Duration duration) {
        long seconds = duration.getSeconds();
        if (seconds > 9223372036L || seconds < -9223372037L) {
            throw new ParsingException(source, "Duration out of range", new Object[0]);
        }
    }

    @Override
    public List<String> visitLabelList(PromqlBaseParser.LabelListContext ctx) {
        return ctx != null ? ParserUtils.visitList(this, ctx.labelName(), String.class) : Collections.emptyList();
    }

    @Override
    public String visitLabelName(PromqlBaseParser.LabelNameContext ctx) {
        if (ctx.identifier() != null) {
            return this.visitIdentifier(ctx.identifier());
        }
        if (ctx.STRING() != null) {
            return this.string(ctx.STRING());
        }
        if (ctx.number() != null) {
            Literal l = ParserUtils.typedParsing(this, (ParseTree)ctx.number(), Literal.class);
            return String.valueOf(l.value());
        }
        throw new ParsingException(this.source(ctx), "Expected label name, got [{}]", this.source(ctx).text());
    }

    @Override
    public Evaluation visitEvaluation(PromqlBaseParser.EvaluationContext ctx) {
        PromqlBaseParser.OffsetContext offsetContext;
        if (ctx == null) {
            return Evaluation.NONE;
        }
        Literal offset = Literal.NULL;
        boolean negativeOffset = false;
        Literal at = Literal.NULL;
        PromqlBaseParser.AtContext atCtx = ctx.at();
        if (atCtx != null) {
            Source source = this.source(atCtx);
            if (atCtx.AT_START() != null) {
                if (this.start == null) {
                    throw new ParsingException(source, "@ start() can only be used if parameter [start] or [time] is provided", new Object[0]);
                }
                at = this.start;
            } else if (atCtx.AT_END() != null) {
                if (this.end == null) {
                    throw new ParsingException(source, "@ end() can only be used if parameter [end] or [time] is provided", new Object[0]);
                }
                at = this.end;
            } else {
                Duration timeValue = this.visitTimeValue(atCtx.timeValue());
                long seconds = timeValue.getSeconds();
                int nanos = timeValue.getNano();
                if (atCtx.MINUS() != null) {
                    if (seconds == Long.MIN_VALUE) {
                        throw new ParsingException(source, "Value [{}] cannot be negated due to underflow", seconds);
                    }
                    seconds = -seconds;
                    nanos = -nanos;
                }
                at = Literal.dateTime(source, Instant.ofEpochSecond(seconds, nanos));
            }
        }
        if ((offsetContext = ctx.offset()) != null) {
            offset = this.visitDuration(offsetContext.duration());
            negativeOffset = offsetContext.MINUS() != null;
        }
        return new Evaluation(offset, negativeOffset, at);
    }

    @Override
    public Literal visitDuration(PromqlBaseParser.DurationContext ctx) {
        Object o;
        if (ctx == null) {
            return Literal.NULL;
        }
        Object object = o = this.visit((ParseTree)ctx.expression());
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        Object object3 = o = (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LogicalPlan.class, Literal.class, Expression.class}, (Object)object2, n)) {
            case 0 -> {
                LogicalPlan plan = (LogicalPlan)object2;
                if (plan instanceof LiteralSelector) {
                    LiteralSelector literalSelector = (LiteralSelector)plan;
                    yield literalSelector.literal().value();
                }
                throw new ParsingException(this.source(ctx), "Expected duration or numeric value, got [{}]", plan.getClass().getSimpleName());
            }
            case 1 -> {
                Literal l = (Literal)object2;
                yield l.value();
            }
            case 2 -> {
                Expression e = (Expression)object2;
                if (e.foldable()) {
                    yield e.fold(FoldContext.small());
                }
                throw new ParsingException(this.source(ctx), "Expected a duration, got [{}]", this.source(ctx).text());
            }
            default -> o;
        });
        Objects.requireNonNull(object3);
        Object object4 = object3;
        int n2 = 0;
        Duration d = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Duration.class, Number.class}, (Object)object4, n2)) {
            case 0 -> {
                Duration duration;
                yield duration = (Duration)object4;
            }
            case 1 -> {
                Number num = (Number)object4;
                long seconds = num.longValue();
                if (seconds <= 0L) {
                    throw new ParsingException(this.source(ctx), "Duration must be positive, got [{}]s", seconds);
                }
                Duration duration = Duration.ofSeconds(seconds);
                PromqlExpressionBuilder.validateDurationRange(this.source(ctx), duration);
                yield duration;
            }
            default -> throw new ParsingException(this.source(ctx), "Expected a duration, got [{}]", this.source(ctx).text());
        };
        return Literal.timeDuration(this.source(ctx), d);
    }

    @Override
    public Duration visitTimeValue(PromqlBaseParser.TimeValueContext ctx) {
        if (ctx.number() != null) {
            Literal literal = ParserUtils.typedParsing(this, (ParseTree)ctx.number(), Literal.class);
            Number number = (Number)literal.value();
            if (number instanceof Double) {
                Double d = (Double)number;
                double v = d;
                Source source = literal.source();
                if (!Double.isFinite(v)) {
                    throw new ParsingException(source, "Invalid timestamp [{}]", v);
                }
                if (v > 9.223372036E9 || v < -9.223372037E9) {
                    throw new ParsingException(source, "Duration out of range", new Object[0]);
                }
                double millisDouble = v * 1000.0;
                if (millisDouble >= 9.223372036854776E18 || millisDouble <= -9.223372036854776E18) {
                    throw new ParsingException(source, "Timestamp out of bounds [{}]", v);
                }
                long millis = Math.round(millisDouble);
                return Duration.ofMillis(millis);
            }
            long longValue = number.longValue();
            if (longValue > 9223372036L || longValue < -9223372037L) {
                throw new ParsingException(literal.source(), "Duration out of range", new Object[0]);
            }
            return Duration.ofSeconds(longValue);
        }
        String timeString = null;
        TerminalNode timeCtx = ctx.TIME_VALUE_WITH_COLON();
        if (timeCtx != null) {
            timeString = timeCtx.getText().substring(1).trim();
        } else {
            timeCtx = ctx.TIME_VALUE();
            timeString = timeCtx.getText();
        }
        Source source = this.source(timeCtx);
        return PromqlExpressionBuilder.parseTimeValue(source, timeString);
    }

    @Override
    public Literal visitDecimalLiteral(PromqlBaseParser.DecimalLiteralContext ctx) {
        Source source = this.source(ctx);
        String text = ctx.getText();
        try {
            String s = text.toLowerCase(Locale.ROOT);
            double value = "inf".equals(s) ? Double.POSITIVE_INFINITY : ("nan".equals(s) ? Double.NaN : Double.parseDouble(text));
            return Literal.fromDouble(source, value);
        }
        catch (NumberFormatException ne) {
            throw new ParsingException(source, "Cannot parse number [{}]", text);
        }
    }

    @Override
    public Literal visitIntegerLiteral(PromqlBaseParser.IntegerLiteralContext ctx) {
        Number value;
        Source source = this.source(ctx);
        String text = ctx.getText();
        try {
            value = StringUtils.parseIntegral((String)text);
        }
        catch (InvalidArgumentException siae) {
            try {
                return Literal.fromDouble(source, StringUtils.parseDouble((String)text));
            }
            catch (QlIllegalArgumentException qlIllegalArgumentException) {
                throw new ParsingException(source, siae.getMessage(), new Object[0]);
            }
        }
        return new Literal(source, value, value instanceof Integer ? DataType.INTEGER : DataType.LONG);
    }

    @Override
    public Literal visitHexLiteral(PromqlBaseParser.HexLiteralContext ctx) {
        Number val;
        long value;
        Source source = this.source(ctx);
        String text = ctx.getText();
        DataType type = DataType.LONG;
        try {
            value = Long.parseLong(text.substring(2), 16);
        }
        catch (NumberFormatException e) {
            throw new ParsingException(source, "Cannot parse hexadecimal expression [{}]", text);
        }
        if ((long)((int)value) == value) {
            type = DataType.INTEGER;
            val = (int)value;
        } else {
            val = value;
        }
        return new Literal(source, val, type);
    }

    @Override
    public Literal visitString(PromqlBaseParser.StringContext ctx) {
        Source source = this.source(ctx);
        return Literal.keyword(source, this.string(ctx.STRING()));
    }

    private static Duration parseTimeValue(Source source, String text) {
        Duration duration = PromqlParserUtils.parseDuration(source, text);
        if (duration.isZero()) {
            throw new ParsingException(source, "Invalid time duration [{}], zero value specified", text);
        }
        PromqlExpressionBuilder.validateDurationRange(source, duration);
        return duration;
    }
}

