/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.esql.core.tree.Location;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.parser.ParsingException;

public final class ParserUtils {
    public static final Map<String, ParamClassification> paramClassifications = Maps.newMapWithExpectedSize((int)ParamClassification.values().length);
    private static final int SINGLE_PARAM;
    private static final int DOUBLE_PARAM;

    private ParserUtils() {
    }

    public static Object visit(Function<ParseTree, Object> visitor, ParseTree tree) {
        Object result = visitor.apply(tree);
        Check.notNull(result, "Don't know how to handle context [{}] with value [{}]", tree.getClass(), tree.getText());
        return result;
    }

    public static <T> List<T> visitList(ParseTreeVisitor<?> visitor, List<? extends ParserRuleContext> contexts, Class<T> clazz) {
        if (contexts == null || contexts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> results = new ArrayList<T>(contexts.size());
        for (ParserRuleContext parserRuleContext : contexts) {
            results.add(clazz.cast(visitor.visit((ParseTree)parserRuleContext)));
        }
        return results;
    }

    public static <T> T typedParsing(ParseTreeVisitor<?> visitor, ParseTree ctx, Class<T> type) {
        Object result = ctx.accept(visitor);
        if (type.isInstance(result)) {
            return (T)result;
        }
        throw new ParsingException(ParserUtils.source(ctx), "Invalid query '{}'[{}] given; expected {} but found {}", ctx.getText(), ctx.getClass().getSimpleName(), type.getSimpleName(), result != null ? result.getClass().getSimpleName() : "null");
    }

    public static Source source(ParseTree ctx) {
        if (ctx instanceof ParserRuleContext) {
            return ParserUtils.source((ParserRuleContext)ctx);
        }
        return Source.EMPTY;
    }

    public static Source source(TerminalNode terminalNode) {
        Check.notNull(terminalNode, "terminalNode is null");
        return ParserUtils.source(terminalNode.getSymbol());
    }

    public static Source source(ParserRuleContext parserRuleContext) {
        Check.notNull(parserRuleContext, "parserRuleContext is null");
        Token start = parserRuleContext.start;
        Token stop = parserRuleContext.stop != null ? parserRuleContext.stop : start;
        return ParserUtils.source(start, stop);
    }

    public static Source source(Token token) {
        Check.notNull(token, "token is null");
        String text = token.getInputStream().getText(new Interval(token.getStartIndex(), token.getStopIndex()));
        return new Source(new Location(token.getLine(), token.getCharPositionInLine()), text);
    }

    public static Source source(ParserRuleContext begin, ParserRuleContext end) {
        Check.notNull(begin, "begin is null");
        Check.notNull(end, "end is null");
        Token start = begin.start;
        Token stop = end.stop != null ? end.stop : begin.stop;
        return ParserUtils.source(start, stop);
    }

    public static Source source(TerminalNode begin, ParserRuleContext end) {
        Check.notNull(begin, "begin is null");
        Check.notNull(end, "end is null");
        Token start = begin.getSymbol();
        Token stop = end.stop != null ? end.stop : start;
        return ParserUtils.source(start, stop);
    }

    public static Source source(Token start, Token stop) {
        Check.notNull(start, "start is null");
        stop = stop == null ? start : stop;
        String text = start.getInputStream().getText(new Interval(start.getStartIndex(), stop.getStopIndex()));
        return new Source(new Location(start.getLine(), start.getCharPositionInLine()), text);
    }

    public static String text(ParseTree node) {
        return node == null ? null : node.getText();
    }

    public static String nameOrPosition(Token token) {
        int tokenType = token.getType();
        return switch (tokenType) {
            case 95 -> token.getText().substring(SINGLE_PARAM);
            case 96 -> token.getText().substring(DOUBLE_PARAM);
            default -> "";
        };
    }

    static {
        for (ParamClassification e : ParamClassification.values()) {
            paramClassifications.put(e.name(), e);
        }
        SINGLE_PARAM = "?".length();
        DOUBLE_PARAM = "??".length();
    }

    public static enum ParamClassification {
        VALUE,
        IDENTIFIER,
        PATTERN;

    }
}

