/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.DateUtils;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsStatsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.querydsl.query.SingleValueQuery;

public class PushCountQueryAndTagsToSource
extends PhysicalOptimizerRules.OptimizerRule<AggregateExec> {
    private static final Literal ZERO = new Literal(Source.EMPTY, 0L, DataType.LONG);

    @Override
    protected PhysicalPlan rule(AggregateExec aggregateExec) {
        EsQueryExec queryExec;
        EvalExec evalExec;
        Count count;
        Alias alias;
        Node node;
        if (aggregateExec.aggregates().size() == 2 && (node = aggregateExec.aggregates().getFirst()) instanceof Alias && (node = (alias = (Alias)node).child()) instanceof Count && !(count = (Count)node).hasFilter() && count.field() instanceof Literal && (node = aggregateExec.child()) instanceof EvalExec && (node = (evalExec = (EvalExec)node).child()) instanceof EsQueryExec && (queryExec = (EsQueryExec)node).queryBuilderAndTags().size() > 1) {
            List<EsQueryExec.QueryBuilderAndTags> withFilter = PushCountQueryAndTagsToSource.tryMerge(queryExec.queryBuilderAndTags());
            if (withFilter.isEmpty() || !withFilter.stream().allMatch(PushCountQueryAndTagsToSource::shouldPush)) {
                return aggregateExec;
            }
            EsStatsQueryExec statsQueryExec = new EsStatsQueryExec(queryExec.source(), queryExec.indexPattern(), null, queryExec.limit(), aggregateExec.output(), new EsStatsQueryExec.ByStat(withFilter));
            Attribute countAttr = statsQueryExec.output().get(1);
            return new FilterExec(Source.EMPTY, statsQueryExec, new GreaterThan(Source.EMPTY, countAttr, ZERO));
        }
        return aggregateExec;
    }

    private static boolean shouldPush(EsQueryExec.QueryBuilderAndTags queryBuilderAndTags) {
        QueryBuilder queryBuilder = queryBuilderAndTags.query();
        Objects.requireNonNull(queryBuilder);
        QueryBuilder queryBuilder2 = queryBuilder;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleValueQuery.Builder.class, RangeQueryBuilder.class, TermQueryBuilder.class, ExistsQueryBuilder.class, BoolQueryBuilder.class}, (Object)queryBuilder2, n)) {
            case 0 -> {
                SingleValueQuery.Builder unused = (SingleValueQuery.Builder)queryBuilder2;
                yield true;
            }
            case 1 -> {
                RangeQueryBuilder unused = (RangeQueryBuilder)queryBuilder2;
                yield true;
            }
            case 2 -> {
                TermQueryBuilder unused = (TermQueryBuilder)queryBuilder2;
                yield true;
            }
            case 3 -> {
                ExistsQueryBuilder unused = (ExistsQueryBuilder)queryBuilder2;
                yield true;
            }
            case 4 -> {
                BoolQueryBuilder bq = (BoolQueryBuilder)queryBuilder2;
                if (bq.filter().size() + bq.must().size() + bq.should().size() + bq.mustNot().size() <= 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static List<EsQueryExec.QueryBuilderAndTags> tryMerge(List<EsQueryExec.QueryBuilderAndTags> queryBuilderAndTags) {
        return queryBuilderAndTags.stream().flatMap(e -> PushCountQueryAndTagsToSource.tryMergeBoolQuery(e).stream()).flatMap(e -> PushCountQueryAndTagsToSource.trySimplifyRange(e).stream()).toList();
    }

    private static Optional<EsQueryExec.QueryBuilderAndTags> trySimplifyRange(EsQueryExec.QueryBuilderAndTags qbt) {
        RangeQueryBuilder rqb;
        QueryBuilder queryBuilder = qbt.query();
        if (queryBuilder instanceof RangeQueryBuilder && (rqb = (RangeQueryBuilder)queryBuilder).from() != null && rqb.to() != null) {
            int comparison = PushCountQueryAndTagsToSource.compare(rqb.from(), rqb.to());
            if (comparison > 0) {
                return Optional.empty();
            }
            if (comparison == 0) {
                return rqb.includeLower() && rqb.includeUpper() ? Optional.of(qbt.withQuery((QueryBuilder)new TermQueryBuilder(rqb.fieldName(), rqb.from()))) : Optional.empty();
            }
            return Optional.of(qbt);
        }
        return Optional.of(qbt);
    }

    private static Optional<EsQueryExec.QueryBuilderAndTags> tryMergeBoolQuery(EsQueryExec.QueryBuilderAndTags qbt) {
        BoolQueryBuilder bqb;
        QueryBuilder queryBuilder = qbt.query();
        if (queryBuilder instanceof BoolQueryBuilder && (bqb = (BoolQueryBuilder)queryBuilder).filter().size() == 2) {
            BoolQueryBuilder internalQuery;
            QueryBuilder filter1 = (QueryBuilder)bqb.filter().get(0);
            RangeQueryBuilder range1 = PushCountQueryAndTagsToSource.tryExtractSingleRangeQuery(filter1);
            QueryBuilder filter2 = (QueryBuilder)bqb.filter().get(1);
            if (range1 != null && filter2 instanceof BoolQueryBuilder && (internalQuery = (BoolQueryBuilder)filter2).mustNot().size() == 1 && internalQuery.mustNot().get(0) instanceof ExistsQueryBuilder) {
                return Optional.empty();
            }
            RangeQueryBuilder range2 = PushCountQueryAndTagsToSource.tryExtractSingleRangeQuery(filter2);
            return Optional.of(PushCountQueryAndTagsToSource.mergeRanges(qbt, range1, range2));
        }
        return Optional.of(qbt);
    }

    private static EsQueryExec.QueryBuilderAndTags mergeRanges(EsQueryExec.QueryBuilderAndTags original, RangeQueryBuilder range1, RangeQueryBuilder range2) {
        return range1 == null || range2 == null ? original : PushCountQueryAndTagsToSource.merge(range1, range2).map(original::withQuery).orElse(original);
    }

    private static Optional<QueryBuilder> merge(RangeQueryBuilder range1, RangeQueryBuilder range2) {
        String format;
        if (!range1.fieldName().equals(range2.fieldName())) {
            return Optional.empty();
        }
        if (!Objects.equals(PushCountQueryAndTagsToSource.nonDefaultTimezone(range1.timeZone()), PushCountQueryAndTagsToSource.nonDefaultTimezone(range2.timeZone()))) {
            return Optional.empty();
        }
        RangeQueryBuilder merged = new RangeQueryBuilder(range1.fieldName());
        PushCountQueryAndTagsToSource.setTighterBound(merged, range1.from(), range2.from(), range1.includeLower(), range2.includeLower(), BoundType.FROM);
        PushCountQueryAndTagsToSource.setTighterBound(merged, range1.to(), range2.to(), range1.includeUpper(), range2.includeUpper(), BoundType.TO);
        String timeZone = range1.timeZone();
        if (timeZone != null) {
            merged.timeZone(timeZone);
        }
        if (range1.format() != null && range2.format() != null && !range1.format().equals(range2.format())) {
            return Optional.empty();
        }
        String string = format = range1.format() != null ? range1.format() : range2.format();
        if (format != null) {
            merged.format(format);
        }
        merged.boost(Math.max(range1.boost(), range2.boost()));
        return Optional.of(merged);
    }

    private static String nonDefaultTimezone(String s) {
        return s == null || s.equals(DateUtils.UTC.getId()) ? null : s;
    }

    @Nullable
    private static RangeQueryBuilder tryExtractSingleRangeQuery(QueryBuilder qb) {
        RangeQueryBuilder rangeQueryBuilder;
        QueryBuilder queryBuilder = qb;
        Objects.requireNonNull(queryBuilder);
        QueryBuilder queryBuilder2 = queryBuilder;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RangeQueryBuilder.class, SingleValueQuery.Builder.class, BoolQueryBuilder.class}, (Object)queryBuilder2, n)) {
                case 0: {
                    RangeQueryBuilder rqb;
                    rangeQueryBuilder = rqb = (RangeQueryBuilder)queryBuilder2;
                    break block5;
                }
                case 1: {
                    SingleValueQuery.Builder single = (SingleValueQuery.Builder)queryBuilder2;
                    rangeQueryBuilder = PushCountQueryAndTagsToSource.tryExtractSingleRangeQuery(single.next());
                    break block5;
                }
                case 2: {
                    BoolQueryBuilder bqb = (BoolQueryBuilder)queryBuilder2;
                    if (bqb.filter().size() != 1) {
                        n = 3;
                        continue block5;
                    }
                    rangeQueryBuilder = PushCountQueryAndTagsToSource.tryExtractSingleRangeQuery((QueryBuilder)bqb.filter().getFirst());
                    break block5;
                }
                default: {
                    rangeQueryBuilder = null;
                    break block5;
                }
            }
            break;
        }
        return rangeQueryBuilder;
    }

    private static void setTighterBound(RangeQueryBuilder range, Object bound1, Object bound2, boolean include1, boolean include2, BoundType boundType) {
        boolean include;
        if (bound1 == null || bound2 == null) {
            if (bound1 != null) {
                PushCountQueryAndTagsToSource.setRange(range, bound1, include1, boundType);
            }
            if (bound2 != null) {
                PushCountQueryAndTagsToSource.setRange(range, bound2, include2, boundType);
            }
            return;
        }
        int compare = PushCountQueryAndTagsToSource.compare(bound1, bound2);
        boolean useFirst = switch (boundType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (compare > 0) {
                    yield true;
                }
                yield false;
            }
            case 1 -> compare < 0;
        };
        Object value = useFirst ? bound1 : bound2;
        boolean bl = include = useFirst ? include1 : include2;
        if (compare == 0) {
            include = include1 && include2;
        }
        PushCountQueryAndTagsToSource.setRange(range, value, include, boundType);
    }

    private static int compare(Object o1, Object o2) {
        return ((Comparable)o1).compareTo(o2);
    }

    private static void setRange(RangeQueryBuilder range, Object val, boolean include, BoundType boundType) {
        switch (boundType.ordinal()) {
            case 0: {
                range.from(val, include);
                break;
            }
            case 1: {
                range.to(val, include);
            }
        }
    }

    static enum BoundType {
        FROM,
        TO;

    }
}

