/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import org.elasticsearch.TransportVersion;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.plugin.EsqlFlags;
import org.elasticsearch.xpack.esql.stats.SearchStats;

public interface LucenePushdownPredicates {
    public static final LucenePushdownPredicates DEFAULT = LucenePushdownPredicates.forCanMatch(null, new EsqlFlags(true));

    @Nullable
    public TransportVersion minTransportVersion();

    public EsqlFlags flags();

    public boolean hasExactSubfield(FieldAttribute var1);

    public boolean isIndexedAndHasDocValues(FieldAttribute var1);

    public boolean isIndexed(FieldAttribute var1);

    public boolean canUseEqualityOnSyntheticSourceDelegate(FieldAttribute var1, String var2);

    default public boolean isPushableFieldAttribute(Expression exp) {
        FieldAttribute fa;
        if (exp instanceof FieldAttribute && (fa = (FieldAttribute)exp).getExactInfo().hasExact() && this.isIndexedAndHasDocValues(fa)) {
            return fa.dataType() != DataType.TEXT || this.hasExactSubfield(fa);
        }
        return false;
    }

    public static boolean isPushableTextFieldAttribute(Expression exp) {
        FieldAttribute fa;
        return exp instanceof FieldAttribute && (fa = (FieldAttribute)exp).dataType() == DataType.TEXT;
    }

    public static boolean isPushableMetadataAttribute(Expression exp) {
        MetadataAttribute ma;
        return exp instanceof MetadataAttribute && ((ma = (MetadataAttribute)exp).searchable() || ma.name().equals("_score"));
    }

    default public boolean isPushableAttribute(Expression exp) {
        return this.isPushableFieldAttribute(exp) || LucenePushdownPredicates.isPushableMetadataAttribute(exp);
    }

    public static TypedAttribute checkIsPushableAttribute(Expression e) {
        Check.isTrue(e instanceof FieldAttribute || e instanceof MetadataAttribute, "Expected a FieldAttribute or MetadataAttribute but received [{}]", e);
        return (TypedAttribute)e;
    }

    public static FieldAttribute checkIsFieldAttribute(Expression e) {
        Check.isTrue(e instanceof FieldAttribute, "Expected a FieldAttribute but received [{}] of type [{}]", e, e.getClass());
        return (FieldAttribute)e;
    }

    public static String pushableAttributeName(TypedAttribute attribute) {
        String string;
        if (attribute instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)attribute;
            string = fa.exactAttribute().name();
        } else {
            string = attribute.name();
        }
        return string;
    }

    public static LucenePushdownPredicates forCanMatch(final TransportVersion minTransportVersion, final EsqlFlags flags) {
        return new LucenePushdownPredicates(){

            @Override
            public TransportVersion minTransportVersion() {
                return minTransportVersion;
            }

            @Override
            public EsqlFlags flags() {
                return flags;
            }

            @Override
            public boolean hasExactSubfield(FieldAttribute attr) {
                return false;
            }

            @Override
            public boolean isIndexedAndHasDocValues(FieldAttribute attr) {
                return attr.field().isAggregatable();
            }

            @Override
            public boolean isIndexed(FieldAttribute attr) {
                return attr.field().isAggregatable();
            }

            @Override
            public boolean canUseEqualityOnSyntheticSourceDelegate(FieldAttribute attr, String value) {
                return false;
            }
        };
    }

    public static LucenePushdownPredicates from(final SearchStats stats, final EsqlFlags flags) {
        return new LucenePushdownPredicates(){

            @Override
            public TransportVersion minTransportVersion() {
                return null;
            }

            @Override
            public EsqlFlags flags() {
                return flags;
            }

            @Override
            public boolean hasExactSubfield(FieldAttribute attr) {
                return stats.hasExactSubfield(new FieldAttribute.FieldName(attr.name()));
            }

            @Override
            public boolean isIndexedAndHasDocValues(FieldAttribute attr) {
                return attr.field().isAggregatable() || stats.isIndexed(new FieldAttribute.FieldName(attr.name())) && stats.hasDocValues(new FieldAttribute.FieldName(attr.name()));
            }

            @Override
            public boolean isIndexed(FieldAttribute attr) {
                return stats.isIndexed(new FieldAttribute.FieldName(attr.name()));
            }

            @Override
            public boolean canUseEqualityOnSyntheticSourceDelegate(FieldAttribute attr, String value) {
                return stats.canUseEqualityOnSyntheticSourceDelegate(attr.fieldName(), value);
            }
        };
    }
}

