/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical.local;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.FunctionEsField;
import org.elasticsearch.xpack.esql.expression.function.blockloader.BlockLoaderExpression;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.local.EsqlProject;
import org.elasticsearch.xpack.esql.rule.ParameterizedRule;

public class PushExpressionsToFieldLoad
extends ParameterizedRule<LogicalPlan, LogicalPlan, LocalLogicalOptimizerContext> {
    @Override
    public LogicalPlan apply(LogicalPlan plan, LocalLogicalOptimizerContext context) {
        Rule rule = new Rule(context);
        return plan.transformDown(LogicalPlan.class, rule::doRule);
    }

    private class Rule {
        private final Map<Attribute.IdIgnoringWrapper, Attribute> addedAttrs = new HashMap<Attribute.IdIgnoringWrapper, Attribute>();
        private final LocalLogicalOptimizerContext context;
        private final Primaries primaries = new Primaries();
        private boolean addedNewAttribute = false;

        private Rule(LocalLogicalOptimizerContext context) {
            this.context = context;
        }

        private LogicalPlan doRule(LogicalPlan plan) {
            this.addedNewAttribute = false;
            if (plan instanceof Eval || plan instanceof Filter || plan instanceof Aggregate) {
                return this.transformPotentialInvocation(plan);
            }
            if (this.addedAttrs.isEmpty()) {
                return plan;
            }
            if (plan instanceof Project) {
                Project project = (Project)plan;
                return this.transformProject(project);
            }
            if (plan instanceof EsRelation) {
                EsRelation rel = (EsRelation)plan;
                return this.transformRelation(rel);
            }
            return plan;
        }

        private LogicalPlan transformPotentialInvocation(LogicalPlan plan) {
            LogicalPlan transformedPlan = (LogicalPlan)plan.transformExpressionsOnly(Expression.class, e -> {
                if (e instanceof BlockLoaderExpression) {
                    BlockLoaderExpression ble = (BlockLoaderExpression)((Object)e);
                    return this.transformExpression(plan, (Expression)e, ble);
                }
                return e;
            });
            if (!this.addedNewAttribute) {
                return plan;
            }
            return new EsqlProject(Source.EMPTY, transformedPlan, transformedPlan.output());
        }

        private Expression transformExpression(LogicalPlan nodeWithExpression, Expression e, BlockLoaderExpression ble) {
            BlockLoaderExpression.PushedBlockLoaderExpression fuse = ble.tryPushToFieldLoading(this.context.searchStats());
            if (fuse == null) {
                return e;
            }
            List<EsRelation> planPrimaries = this.primaries.primariesFor(nodeWithExpression);
            PushExpressionsToFieldLoad.this.log.trace("found primaries {} {}", new Object[]{nodeWithExpression, planPrimaries});
            if (planPrimaries.size() != 1) {
                return e;
            }
            MappedFieldType.FieldExtractPreference preference = this.context.configuration().pragmas().fieldExtractPreference();
            if (!this.context.searchStats().supportsLoaderConfig(fuse.field().fieldName(), fuse.config(), preference)) {
                return e;
            }
            this.addedNewAttribute = true;
            return this.replaceFieldsForFieldTransformations(e, fuse);
        }

        private LogicalPlan transformProject(Project project) {
            ArrayList<? extends NamedExpression> projections = new ArrayList<NamedExpression>(project.projections());
            projections.addAll(this.addedAttrs.values());
            return project.withProjections(projections);
        }

        private LogicalPlan transformRelation(EsRelation rel) {
            if (rel.indexMode() == IndexMode.LOOKUP) {
                return rel;
            }
            AttributeSet updatedOutput = rel.outputSet().combine(AttributeSet.of(this.addedAttrs.values()));
            return rel.withAttributes(updatedOutput.stream().toList());
        }

        private Expression replaceFieldsForFieldTransformations(Expression e, BlockLoaderExpression.PushedBlockLoaderExpression fuse) {
            FunctionEsField functionEsField = new FunctionEsField(fuse.field().field(), e.dataType(), fuse.config());
            String name = Attribute.rawTemporaryName(fuse.field().name(), fuse.config().function().toString(), String.valueOf(fuse.config().hashCode()));
            FieldAttribute newFunctionAttr = new FieldAttribute(fuse.field().source(), fuse.field().parentName(), fuse.field().qualifier(), name, functionEsField, fuse.field().nullable(), new NameId(), true);
            Attribute.IdIgnoringWrapper key = newFunctionAttr.ignoreId();
            if (this.addedAttrs.containsKey(key)) {
                return this.addedAttrs.get(key);
            }
            this.addedAttrs.put(key, newFunctionAttr);
            return newFunctionAttr;
        }
    }

    private class Primaries {
        private Map<LogicalPlan, List<EsRelation>> primaries = new IdentityHashMap<LogicalPlan, List<EsRelation>>();

        private Primaries() {
        }

        List<EsRelation> primariesFor(LogicalPlan plan) {
            this.scanSubtree(plan);
            return this.primaries.get(plan);
        }

        private void scanSubtree(LogicalPlan plan) {
            if (this.primaries.containsKey(plan)) {
                return;
            }
            if (plan.children().isEmpty()) {
                this.onLeaf(plan);
            } else {
                for (LogicalPlan child : plan.children()) {
                    this.scanSubtree(child);
                }
                this.onInner(plan);
            }
        }

        private void onLeaf(LogicalPlan plan) {
            if (plan instanceof EsRelation) {
                EsRelation rel = (EsRelation)plan;
                if (rel.indexMode() == IndexMode.LOOKUP) {
                    this.primaries.put(plan, List.of());
                } else {
                    this.primaries.put(rel, List.of(rel));
                }
            } else {
                this.primaries.put(plan, List.of());
            }
        }

        private void onInner(LogicalPlan plan) {
            ArrayList<EsRelation> result = new ArrayList<EsRelation>(plan.children().size());
            for (LogicalPlan child : plan.children()) {
                List<EsRelation> childPrimaries = this.primaries.get(child);
                assert (childPrimaries != null) : "scanned depth first " + String.valueOf(child);
                if (childPrimaries.isEmpty()) {
                    PushExpressionsToFieldLoad.this.log.trace("{} unsupported primaries {}", new Object[]{plan, child});
                    this.primaries.put(plan, List.of());
                    return;
                }
                result.addAll(childPrimaries);
            }
            PushExpressionsToFieldLoad.this.log.trace("{} primaries {}", new Object[]{plan, result});
            this.primaries.put(plan, result);
        }
    }
}

