/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical.local;

import java.util.List;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.RuleUtils;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;

public class PruneLeftJoinOnNullMatchingField
extends OptimizerRules.ParameterizedOptimizerRule<Join, LogicalOptimizerContext> {
    public PruneLeftJoinOnNullMatchingField() {
        super(OptimizerRules.TransformDirection.DOWN);
    }

    @Override
    protected LogicalPlan rule(Join join, LogicalOptimizerContext ctx) {
        LogicalPlan plan = join;
        if (join.config().type() == JoinTypes.LEFT) {
            AttributeMap<Expression> attributeMap = RuleUtils.foldableReferences(join, ctx);
            for (Attribute attr : AttributeSet.of(join.config().leftFields())) {
                Expression resolved = attributeMap.resolve(attr);
                if (resolved == null || !Expressions.isGuaranteedNull(resolved)) continue;
                plan = PruneLeftJoinOnNullMatchingField.replaceJoin(join);
                break;
            }
        }
        return plan;
    }

    private static LogicalPlan replaceJoin(Join join) {
        List<Attribute> joinRightOutput = join.rightOutputFields();
        if (joinRightOutput.isEmpty()) {
            return join.left();
        }
        Tuple<List<Alias>, List<NamedExpression>> aliasedNulls = RuleUtils.aliasedNulls(joinRightOutput, a -> true);
        Eval eval = new Eval(join.source(), join.left(), (List)aliasedNulls.v1());
        return new Project(join.source(), eval, join.computeOutputExpressions(join.left().output(), (List)aliasedNulls.v2()));
    }
}

