/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.TemporaryNameUtils;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.rule.Rule;

public final class ReplaceAliasingEvalWithProject
extends Rule<LogicalPlan, LogicalPlan> {
    @Override
    public LogicalPlan apply(LogicalPlan logicalPlan) {
        Holder enabled = new Holder((Object)false);
        return logicalPlan.transformDown(p -> {
            if (p instanceof Aggregate || p instanceof Project) {
                enabled.set((Object)true);
            } else if (((Boolean)enabled.get()).booleanValue() && p instanceof Eval) {
                Eval eval = (Eval)p;
                p = this.rule(eval);
            }
            return p;
        });
    }

    private LogicalPlan rule(Eval eval) {
        UnaryPlan plan = eval;
        AttributeMap.Builder<Attribute> renamesToPropagate = AttributeMap.builder();
        AttributeMap.Builder<Alias> projectionAliases = AttributeMap.builder();
        HashSet<String> namesRequiredForProjectionAliases = new HashSet<String>();
        ArrayList<Alias> newEvalFields = new ArrayList<Alias>();
        List<Alias> fields = eval.fields();
        for (Alias alias : fields) {
            Alias field = (Alias)alias.transformUp(e -> renamesToPropagate.build().resolve(e, (Expression)e));
            String name = field.name();
            Attribute attribute = field.toAttribute();
            Expression child = field.child();
            if (child instanceof Attribute) {
                Attribute renamedAttribute = (Attribute)child;
                renamesToPropagate.put(attribute, renamedAttribute);
                projectionAliases.put(attribute, field);
                namesRequiredForProjectionAliases.add(renamedAttribute.name());
                continue;
            }
            if (namesRequiredForProjectionAliases.contains(name)) {
                Alias newField = new Alias(field.source(), TemporaryNameUtils.locallyUniqueTemporaryName(name), child, null, true);
                Attribute newAttribute = newField.toAttribute();
                Alias reRenamedField = new Alias(field.source(), name, newAttribute, field.id(), field.synthetic());
                projectionAliases.put(attribute, reRenamedField);
                renamesToPropagate.put(attribute, newAttribute);
                newEvalFields.add(newField);
                continue;
            }
            newEvalFields.add(field);
        }
        if (renamesToPropagate.build().size() > 0) {
            ArrayList<Attribute> projections = new ArrayList<Attribute>(eval.output());
            AttributeMap<NamedExpression> projectionAliasesMap = projectionAliases.build();
            for (int i = projections.size() - 1; i >= 0; --i) {
                NamedExpression project = (NamedExpression)projections.get(i);
                projections.set(i, (Attribute)projectionAliasesMap.getOrDefault((Object)project, project));
            }
            LogicalPlan child = eval.child();
            if (newEvalFields.size() > 0) {
                child = new Eval(eval.source(), eval.child(), newEvalFields);
            }
            plan = new Project(eval.source(), child, projections);
        }
        return plan;
    }
}

