/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.tree.Location;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public final class RemoveStatsOverride
extends OptimizerRules.OptimizerRule<Aggregate> {
    @Override
    protected LogicalPlan rule(Aggregate aggregate) {
        return aggregate.with(RemoveStatsOverride.removeDuplicateNames(aggregate.groupings()), RemoveStatsOverride.removeDuplicateNames(aggregate.aggregates()));
    }

    private static <T extends Expression> List<T> removeDuplicateNames(List<T> list) {
        ArrayList<T> newList = new ArrayList<T>(list);
        Map expressionsByName = Maps.newMapWithExpectedSize((int)list.size());
        for (int i = list.size() - 1; i >= 0; --i) {
            Expression element = (Expression)list.get(i);
            String name = Expressions.name(element);
            Expression previousExpression = expressionsByName.putIfAbsent(name, element);
            if (previousExpression == null) continue;
            Location source = element.source().source();
            Location previousSource = previousExpression.source().source();
            HeaderWarning.addWarning((String)"Line {}:{}: Field '{}' shadowed by field at line {}:{}", (Object[])new Object[]{source.getLineNumber(), source.getColumnNumber(), name, previousSource.getLineNumber(), previousSource.getColumnNumber()});
            newList.remove(i);
        }
        return newList.size() == list.size() ? list : newList;
    }
}

