/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownUtils;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.TemporaryNameUtils;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.join.InlineJoin;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;

public final class PushDownJoinPastProject
extends OptimizerRules.OptimizerRule<Join> {
    @Override
    protected LogicalPlan rule(Join join) {
        if (join instanceof InlineJoin) {
            return join;
        }
        LogicalPlan logicalPlan = join.left();
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            if (join.config().type() == JoinTypes.LEFT) {
                AttributeMap.Builder aliasBuilder = AttributeMap.builder();
                project.forEachExpression(Alias.class, a -> aliasBuilder.put(a.toAttribute(), a.child()));
                AttributeMap<Expression> aliasesFromProject = aliasBuilder.build();
                Join updatedJoin = PushDownUtils.resolveRenamesFromMap(join, aliasesFromProject);
                List<Attribute> originalOutput = join.output();
                ArrayList<NamedExpression> newProjections = new ArrayList<NamedExpression>(originalOutput.size());
                for (Attribute attr : originalOutput) {
                    Attribute resolved;
                    if (attr.semanticEquals(resolved = (Attribute)aliasesFromProject.resolve(attr, attr))) {
                        newProjections.add(attr);
                        continue;
                    }
                    Alias renamed = new Alias(attr.source(), attr.name(), resolved, attr.id(), attr.synthetic());
                    newProjections.add(renamed);
                }
                HashSet<String> lookupFieldNames = new HashSet<String>(Expressions.names(join.rightOutputFields()));
                ArrayList<NamedExpression> finalProjections = new ArrayList<NamedExpression>(newProjections.size());
                AttributeMap.Builder<Alias> aliasesForReplacedAttributesBuilder = AttributeMap.builder();
                AttributeSet leftOutput = project.child().outputSet();
                for (NamedExpression newProj : newProjections) {
                    Attribute coreAttr = (Attribute)Alias.unwrap(newProj);
                    if (leftOutput.contains(coreAttr) && lookupFieldNames.contains(coreAttr.name())) {
                        Alias renamedBack;
                        Alias renaming = aliasesForReplacedAttributesBuilder.computeIfAbsent(coreAttr, a -> {
                            String tempName = TemporaryNameUtils.locallyUniqueTemporaryName(a.name());
                            return new Alias(a.source(), tempName, (Expression)a, null, true);
                        });
                        Attribute renamedAttribute = renaming.toAttribute();
                        if (newProj instanceof Alias) {
                            Alias as = (Alias)newProj;
                            renamedBack = new Alias(as.source(), as.name(), renamedAttribute, as.id(), as.synthetic());
                        } else {
                            renamedBack = new Alias(coreAttr.source(), coreAttr.name(), renamedAttribute, coreAttr.id(), coreAttr.synthetic());
                        }
                        finalProjections.add(renamedBack);
                        continue;
                    }
                    finalProjections.add(newProj);
                }
                if (aliasesForReplacedAttributesBuilder.isEmpty()) {
                    return new Project(project.source(), updatedJoin.replaceLeft(project.child()), newProjections);
                }
                ArrayList<Alias> renamesForEval = new ArrayList<Alias>(aliasesForReplacedAttributesBuilder.build().values());
                Eval eval = new Eval(project.source(), project.child(), renamesForEval);
                Join finalJoin = new Join(join.source(), eval, updatedJoin.right(), updatedJoin.config());
                return new Project(project.source(), finalJoin, finalProjections);
            }
        }
        return join;
    }
}

