/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.predicate.logical.And;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneEmptyPlans;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public final class PruneFilters
extends OptimizerRules.OptimizerRule<Filter> {
    @Override
    protected LogicalPlan rule(Filter filter) {
        Expression condition = filter.condition().transformUp(BinaryLogic.class, PruneFilters::foldBinaryLogic);
        if (condition instanceof Literal) {
            if (Literal.TRUE.equals(condition)) {
                return filter.child();
            }
            if (Literal.FALSE.equals(condition) || Expressions.isGuaranteedNull(condition)) {
                return PruneEmptyPlans.skipPlan(filter);
            }
        }
        if (!condition.equals(filter.condition())) {
            return new Filter(filter.source(), filter.child(), condition);
        }
        return filter;
    }

    private static Expression foldBinaryLogic(BinaryLogic binaryLogic) {
        And and;
        if (binaryLogic instanceof Or) {
            Or or = (Or)binaryLogic;
            boolean nullLeft = Expressions.isGuaranteedNull(or.left());
            boolean nullRight = Expressions.isGuaranteedNull(or.right());
            if (nullLeft && nullRight) {
                return new Literal(binaryLogic.source(), null, DataType.NULL);
            }
            if (nullLeft) {
                return or.right();
            }
            if (nullRight) {
                return or.left();
            }
        }
        if (binaryLogic instanceof And && (Expressions.isGuaranteedNull((and = (And)binaryLogic).left()) || Expressions.isGuaranteedNull(and.right()))) {
            return new Literal(binaryLogic.source(), null, DataType.NULL);
        }
        return binaryLogic;
    }
}

