/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.util.ReflectionUtils;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.rule.ParameterizedRule;
import org.elasticsearch.xpack.esql.rule.Rule;

public final class OptimizerRules {

    public static interface CoordinatorOnly
    extends LocalAware<LogicalPlan> {
        @Override
        default public Rule<LogicalPlan, LogicalPlan> local() {
            return null;
        }
    }

    public static interface LocalAware<SubPlan extends LogicalPlan> {
        public Rule<SubPlan, LogicalPlan> local();
    }

    public static abstract class ParameterizedOptimizerRule<SubPlan extends LogicalPlan, P>
    extends ParameterizedRule<SubPlan, LogicalPlan, P> {
        private final TransformDirection direction;

        protected ParameterizedOptimizerRule(TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan, P context) {
            return this.direction == TransformDirection.DOWN ? plan.transformDown(this.typeToken(), t -> this.rule(t, context)) : plan.transformUp(this.typeToken(), t -> this.rule(t, context));
        }

        protected abstract LogicalPlan rule(SubPlan var1, P var2);
    }

    public static enum TransformDirection {
        UP,
        DOWN;

    }

    public static abstract class OptimizerExpressionRule<E extends Expression>
    extends ParameterizedRule<LogicalPlan, LogicalPlan, LogicalOptimizerContext> {
        private final TransformDirection direction;
        private final Class<E> expressionTypeToken = ReflectionUtils.detectSuperTypeForRuleLike(this.getClass());

        public OptimizerExpressionRule(TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan, LogicalOptimizerContext ctx) {
            return this.direction == TransformDirection.DOWN ? (LogicalPlan)plan.transformExpressionsDown(this::shouldVisit, this.expressionTypeToken, e -> this.rule(e, ctx)) : (LogicalPlan)plan.transformExpressionsUp(this::shouldVisit, this.expressionTypeToken, e -> this.rule(e, ctx));
        }

        protected abstract Expression rule(E var1, LogicalOptimizerContext var2);

        protected boolean shouldVisit(Node<?> node) {
            Node<?> node2 = node;
            Objects.requireNonNull(node2);
            Node<?> node3 = node2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EsRelation.class, Project.class, Limit.class}, node3, n)) {
                case 0 -> {
                    EsRelation relation = (EsRelation)node3;
                    yield false;
                }
                case 1 -> {
                    Project project = (Project)node3;
                    yield false;
                }
                case 2 -> {
                    Limit limit = (Limit)node3;
                    yield false;
                }
                default -> true;
            };
        }

        public Class<E> expressionToken() {
            return this.expressionTypeToken;
        }
    }

    public static abstract class OptimizerRule<SubPlan extends LogicalPlan>
    extends Rule<SubPlan, LogicalPlan> {
        private final TransformDirection direction;

        public OptimizerRule() {
            this(TransformDirection.DOWN);
        }

        protected OptimizerRule(TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return this.direction == TransformDirection.DOWN ? plan.transformDown(this.typeToken(), this::rule) : plan.transformUp(this.typeToken(), this::rule);
        }

        protected abstract LogicalPlan rule(SubPlan var1);
    }
}

