/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;

public class FoldNull
extends OptimizerRules.OptimizerExpressionRule<Expression> {
    public FoldNull() {
        super(OptimizerRules.TransformDirection.UP);
    }

    @Override
    public Expression rule(Expression e, LogicalOptimizerContext ctx) {
        AggregateFunction agg;
        Expression result = this.tryReplaceIsNullIsNotNull(e);
        if (e instanceof AggregateFunction && Expressions.isGuaranteedNull((agg = (AggregateFunction)e).filter())) {
            return agg.withFilter(Literal.of(agg.filter(), false));
        }
        if (result != e) {
            return result;
        }
        if (e instanceof In) {
            In in = (In)e;
            if (Expressions.isGuaranteedNull(in.value())) {
                return Literal.of(in, null);
            }
        } else if (!(e instanceof Alias) && e.nullable() == Nullability.TRUE && !(e instanceof GroupingFunction.NonEvaluatableGroupingFunction) && Expressions.anyMatch(e.children(), Expressions::isGuaranteedNull)) {
            return Literal.of(e, null);
        }
        return e;
    }

    protected Expression tryReplaceIsNullIsNotNull(Expression e) {
        return e;
    }
}

