/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.List;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Values;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.ProjectAwayColumns;
import org.elasticsearch.xpack.esql.plan.QueryPlan;
import org.elasticsearch.xpack.esql.plan.logical.TimeSeriesAggregate;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;

public abstract class PostOptimizationPhasePlanVerifier<P extends QueryPlan<P>> {
    protected final boolean isLocal;

    protected PostOptimizationPhasePlanVerifier(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public Failures verify(P optimizedPlan, List<Attribute> expectedOutputAttributes) {
        Failures failures = new Failures();
        Failures depFailures = new Failures();
        this.checkPlanConsistency(optimizedPlan, failures, depFailures);
        PostOptimizationPhasePlanVerifier.verifyOutputNotChanged(optimizedPlan, expectedOutputAttributes, failures);
        if (depFailures.hasFailures()) {
            throw new IllegalStateException(depFailures.toString());
        }
        return failures;
    }

    abstract void checkPlanConsistency(P var1, Failures var2, Failures var3);

    private static void verifyOutputNotChanged(QueryPlan<?> optimizedPlan, List<Attribute> expectedOutputAttributes, Failures failures) {
        if (failures.hasFailures()) {
            return;
        }
        if (!Attribute.dataTypeEquals(expectedOutputAttributes, optimizedPlan.output())) {
            boolean ignoreError;
            EsQueryExec esQueryExec;
            boolean hasProjectAwayColumns = optimizedPlan.output().stream().anyMatch(x -> x.name().equals(ProjectAwayColumns.ALL_FIELDS_PROJECTED));
            boolean hasLookupJoinExec = optimizedPlan instanceof EsQueryExec && (esQueryExec = (EsQueryExec)optimizedPlan).indexMode() == IndexMode.LOOKUP;
            boolean hasTextGroupingInTimeSeries = optimizedPlan.anyMatch(a -> {
                TimeSeriesAggregate ts;
                return a instanceof TimeSeriesAggregate && (ts = (TimeSeriesAggregate)a).aggregates().stream().anyMatch(g -> {
                    Values v;
                    Expression patt0$temp = Alias.unwrap(g);
                    return patt0$temp instanceof Values && (v = (Values)patt0$temp).field().dataType() == DataType.TEXT;
                });
            });
            boolean hasTimeSeriesReplacingTsId = optimizedPlan.anyMatch(a -> {
                TimeSeriesAggregate ts;
                return a instanceof TimeSeriesAggregate && (ts = (TimeSeriesAggregate)a).output().stream().anyMatch(MetadataAttribute::isTimeSeriesAttribute) && expectedOutputAttributes.stream().noneMatch(MetadataAttribute::isTimeSeriesAttribute);
            });
            boolean bl = ignoreError = hasProjectAwayColumns || hasLookupJoinExec || hasTextGroupingInTimeSeries || hasTimeSeriesReplacingTsId;
            if (!ignoreError) {
                failures.add(Failure.fail(optimizedPlan, "Output has changed from [{}] to [{}]. ", expectedOutputAttributes.toString(), optimizedPlan.output().toString()));
            }
        }
    }
}

