/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.io.stream;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;

public class ExpressionQueryBuilder
extends AbstractQueryBuilder<ExpressionQueryBuilder>
implements MultiTermQueryBuilder {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(QueryBuilder.class, "expressionQueryBuilder", ExpressionQueryBuilder::new);
    private final String fieldName;
    private final Expression expression;

    public ExpressionQueryBuilder(String fieldName, Expression expression) {
        if (Strings.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null");
        }
        this.fieldName = fieldName;
        this.expression = expression;
    }

    private ExpressionQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        assert (in instanceof PlanStreamInput);
        this.expression = (Expression)in.readNamedWriteable(Expression.class);
    }

    public Expression getExpression() {
        return this.expression;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        assert (out instanceof PlanStreamOutput);
        out.writeNamedWriteable((NamedWriteable)this.expression);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String getWriteableName() {
        return ExpressionQueryBuilder.ENTRY.name;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(ExpressionQueryBuilder.ENTRY.name);
        builder.field("field", this.fieldName);
        builder.field("expression", this.expression.toString());
        builder.endObject();
    }

    protected Query doToQuery(SearchExecutionContext context) {
        Expression expression = this.expression;
        if (expression instanceof TranslationAware) {
            TranslationAware translationAware = (TranslationAware)((Object)expression);
            MappedFieldType fieldType = context.getFieldType(this.fieldName);
            if (fieldType == null) {
                return new MatchNoDocsQuery("Field [" + this.fieldName + "] does not exist");
            }
            return translationAware.asLuceneQuery(fieldType, MultiTermQuery.CONSTANT_SCORE_REWRITE, context);
        }
        throw new UnsupportedOperationException("ExpressionQueryBuilder does not support non-automaton expressions");
    }

    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.expression);
    }

    protected boolean doEquals(ExpressionQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.expression, other.expression);
    }

    public TransportVersion getMinimalSupportedVersion() {
        throw new UnsupportedOperationException("AutomatonQueryBuilder does not support getMinimalSupportedVersion");
    }
}

