/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.promql.subquery;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.Evaluation;

public class Subquery
extends UnaryPlan {
    private final Literal range;
    private final Literal resolution;
    private final Evaluation evaluation;

    public Subquery(Source source, LogicalPlan child, Literal range, Literal resolution, Evaluation evaluation) {
        super(source, child);
        this.range = range;
        this.resolution = resolution;
        this.evaluation = evaluation;
    }

    public Literal range() {
        return this.range;
    }

    public Literal resolution() {
        return this.resolution;
    }

    public Evaluation evaluation() {
        return this.evaluation;
    }

    @Override
    public boolean expressionsResolved() {
        return true;
    }

    @Override
    protected NodeInfo<Subquery> info() {
        return NodeInfo.create(this, Subquery::new, this.child(), this.range, this.resolution, this.evaluation);
    }

    @Override
    public Subquery replaceChild(LogicalPlan newChild) {
        return new Subquery(this.source(), newChild, this.range, this.resolution, this.evaluation);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subquery subquery = (Subquery)o;
        return Objects.equals(this.range, subquery.range) && Objects.equals(this.resolution, subquery.resolution) && Objects.equals(this.evaluation, subquery.evaluation) && Objects.equals(this.child(), subquery.child());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.child(), this.range, this.resolution, this.evaluation);
    }

    public String getWriteableName() {
        throw new EsqlIllegalArgumentException("should not be serialized");
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new EsqlIllegalArgumentException("should not be serialized");
    }
}

