/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanKeywordsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanMillisNanosEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanNanosMillisEvaluator;

public class LessThan
extends EsqlBinaryComparison
implements Negatable<EsqlBinaryComparison> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "LessThan", EsqlBinaryComparison::readFrom);
    private static final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap = Map.ofEntries(Map.entry(DataType.INTEGER, LessThanIntsEvaluator.Factory::new), Map.entry(DataType.DOUBLE, LessThanDoublesEvaluator.Factory::new), Map.entry(DataType.LONG, LessThanLongsEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, LessThanLongsEvaluator.Factory::new), Map.entry(DataType.DATETIME, LessThanLongsEvaluator.Factory::new), Map.entry(DataType.DATE_NANOS, LessThanLongsEvaluator.Factory::new), Map.entry(DataType.KEYWORD, LessThanKeywordsEvaluator.Factory::new), Map.entry(DataType.TEXT, LessThanKeywordsEvaluator.Factory::new), Map.entry(DataType.VERSION, LessThanKeywordsEvaluator.Factory::new), Map.entry(DataType.IP, LessThanKeywordsEvaluator.Factory::new));

    @FunctionInfo(operator="<", returnType={"boolean"}, description="Check if one field is less than another. If either field is <<esql-multivalued-fields,multivalued>> then the result is `null`.", note="This is pushed to the underlying search index if one side of the comparison is constant and the other side is a field in the index that has both an <<mapping-index>> and <<doc-values>>.")
    public LessThan(Source source, @Param(name="lhs", type={"boolean", "date_nanos", "date", "double", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="An expression.") Expression left, @Param(name="rhs", type={"boolean", "date_nanos", "date", "double", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="An expression.") Expression right) {
        this(source, left, right, null);
    }

    public LessThan(Source source, Expression left, Expression right, ZoneId zoneId) {
        super(source, left, right, EsqlBinaryComparison.BinaryComparisonOperation.LT, zoneId, evaluatorMap, LessThanNanosMillisEvaluator.Factory::new, LessThanMillisNanosEvaluator.Factory::new);
    }

    public String getWriteableName() {
        return LessThan.ENTRY.name;
    }

    @Override
    protected NodeInfo<LessThan> info() {
        return NodeInfo.create(this, LessThan::new, this.left(), this.right(), this.zoneId());
    }

    @Override
    protected LessThan replaceChildren(Expression newLeft, Expression newRight) {
        return new LessThan(this.source(), newLeft, newRight, this.zoneId());
    }

    public GreaterThan swapLeftAndRight() {
        return new GreaterThan(this.source(), this.right(), this.left(), this.zoneId());
    }

    @Override
    public GreaterThanOrEqual negate() {
        return new GreaterThanOrEqual(this.source(), this.left(), this.right(), this.zoneId());
    }

    @Override
    public EsqlBinaryComparison reverse() {
        return new GreaterThan(this.source(), this.left(), this.right(), this.zoneId());
    }

    static boolean processInts(int lhs, int rhs) {
        return lhs < rhs;
    }

    static boolean processLongs(long lhs, long rhs) {
        return lhs < rhs;
    }

    static boolean processMillisNanos(long lhs, long rhs) {
        return DateUtils.compareNanosToMillis((long)rhs, (long)lhs) > 0;
    }

    static boolean processNanosMillis(long lhs, long rhs) {
        return DateUtils.compareNanosToMillis((long)lhs, (long)rhs) < 0;
    }

    static boolean processDoubles(double lhs, double rhs) {
        return lhs < rhs;
    }

    static boolean processKeywords(BytesRef lhs, BytesRef rhs) {
        return lhs.compareTo(rhs) < 0;
    }
}

