/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Add;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.BinaryComparisonInversible;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DateTimeArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.SubDateNanosEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.SubDatetimesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.SubDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.SubIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.SubLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.SubUnsignedLongsEvaluator;

public class Sub
extends DateTimeArithmeticOperation
implements BinaryComparisonInversible {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Sub", Sub::new);

    @FunctionInfo(operator="-", returnType={"double", "integer", "long", "date_period", "datetime", "time_duration", "unsigned_long"}, description="Subtract one number from another. If either field is <<esql-multivalued-fields,multivalued>> then the result is `null`.")
    public Sub(Source source, @Param(name="lhs", description="A numeric value or a date time value.", type={"double", "integer", "long", "date_period", "datetime", "time_duration", "unsigned_long"}) Expression left, @Param(name="rhs", description="A numeric value or a date time value.", type={"double", "integer", "long", "date_period", "datetime", "time_duration", "unsigned_long"}) Expression right) {
        super(source, left, right, EsqlArithmeticOperation.OperationSymbol.SUB, SubIntsEvaluator.Factory::new, SubLongsEvaluator.Factory::new, SubUnsignedLongsEvaluator.Factory::new, SubDoublesEvaluator.Factory::new, SubDatetimesEvaluator.Factory::new, SubDateNanosEvaluator.Factory::new);
    }

    private Sub(StreamInput in) throws IOException {
        super(in, EsqlArithmeticOperation.OperationSymbol.SUB, SubIntsEvaluator.Factory::new, SubLongsEvaluator.Factory::new, SubUnsignedLongsEvaluator.Factory::new, SubDoublesEvaluator.Factory::new, SubDatetimesEvaluator.Factory::new, SubDateNanosEvaluator.Factory::new);
    }

    public String getWriteableName() {
        return Sub.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = super.resolveType();
        if (resolution.resolved() && DataType.isDateTimeOrTemporal(this.dataType()) && DataType.isDateTime(this.right().dataType())) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"[{}] arguments are in unsupported order: cannot subtract a [{}] value [{}] from a [{}] amount [{}]", (Object[])new Object[]{this.symbol(), this.right().dataType(), this.right().sourceText(), this.left().dataType(), this.left().sourceText()}));
        }
        return resolution;
    }

    @Override
    protected NodeInfo<Sub> info() {
        return NodeInfo.create(this, Sub::new, this.left(), this.right());
    }

    @Override
    protected Sub replaceChildren(Expression left, Expression right) {
        return new Sub(this.source(), left, right);
    }

    @Override
    public BinaryComparisonInversible.ArithmeticOperationFactory binaryComparisonInverse() {
        return Add::new;
    }

    static int processInts(int lhs, int rhs) {
        return Math.subtractExact(lhs, rhs);
    }

    static long processLongs(long lhs, long rhs) {
        return Math.subtractExact(lhs, rhs);
    }

    static long processUnsignedLongs(long lhs, long rhs) {
        return NumericUtils.unsignedLongSubtractExact((long)lhs, (long)rhs);
    }

    static double processDoubles(double lhs, double rhs) {
        return NumericUtils.asFiniteNumber((double)(lhs - rhs));
    }

    static long processDatetimes(long datetime, TemporalAmount temporalAmount) {
        return org.elasticsearch.xpack.esql.core.util.DateUtils.asMillis(org.elasticsearch.xpack.esql.core.util.DateUtils.asDateTime(datetime).minus(temporalAmount));
    }

    static long processDateNanos(long dateNanos, TemporalAmount temporalAmount) {
        try {
            return DateUtils.toLong((Instant)Instant.from(ZonedDateTime.ofInstant(DateUtils.toInstant((long)dateNanos), org.elasticsearch.xpack.esql.core.util.DateUtils.UTC).minus(temporalAmount)));
        }
        catch (IllegalArgumentException e) {
            throw new DateTimeException("Date nanos out of range.  Must be between 1970-01-01T00:00:00Z and 2262-04-11T23:47:16.854775807");
        }
    }

    @Override
    public Period fold(Period left, Period right) {
        return left.minus(right);
    }

    @Override
    public Duration fold(Duration left, Duration right) {
        return left.minus(right);
    }
}

