/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.ModDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.ModIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.ModLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.ModUnsignedLongsEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class Mod
extends EsqlArithmeticOperation {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Mod", Mod::new);

    @FunctionInfo(operator="%", returnType={"double", "integer", "long", "unsigned_long"}, description="Divide one number by another and return the remainder. If either field is <<esql-multivalued-fields,multivalued>> then the result is `null`.")
    public Mod(Source source, @Param(name="lhs", description="A numeric value.", type={"double", "integer", "long", "unsigned_long"}) Expression left, @Param(name="rhs", description="A numeric value.", type={"double", "integer", "long", "unsigned_long"}) Expression right) {
        super(source, left, right, EsqlArithmeticOperation.OperationSymbol.MOD, ModIntsEvaluator.Factory::new, ModLongsEvaluator.Factory::new, ModUnsignedLongsEvaluator.Factory::new, ModDoublesEvaluator.Factory::new);
    }

    private Mod(StreamInput in) throws IOException {
        super(in, EsqlArithmeticOperation.OperationSymbol.MOD, ModIntsEvaluator.Factory::new, ModLongsEvaluator.Factory::new, ModUnsignedLongsEvaluator.Factory::new, ModDoublesEvaluator.Factory::new);
    }

    public String getWriteableName() {
        return Mod.ENTRY.name;
    }

    @Override
    protected NodeInfo<Mod> info() {
        return NodeInfo.create(this, Mod::new, this.left(), this.right());
    }

    @Override
    protected Mod replaceChildren(Expression left, Expression right) {
        return new Mod(this.source(), left, right);
    }

    static int processInts(int lhs, int rhs) {
        if (rhs == 0) {
            throw new ArithmeticException("/ by zero");
        }
        return lhs % rhs;
    }

    static long processLongs(long lhs, long rhs) {
        if (rhs == 0L) {
            throw new ArithmeticException("/ by zero");
        }
        return lhs % rhs;
    }

    static long processUnsignedLongs(long lhs, long rhs) {
        if (rhs == NumericUtils.ZERO_AS_UNSIGNED_LONG) {
            throw new ArithmeticException("/ by zero");
        }
        return EsqlDataTypeConverter.longToUnsignedLong(Long.remainderUnsigned(EsqlDataTypeConverter.longToUnsignedLong(lhs, true), EsqlDataTypeConverter.longToUnsignedLong(rhs, true)), true);
    }

    static double processDoubles(double lhs, double rhs) {
        double value = lhs % rhs;
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new ArithmeticException("/ by zero");
        }
        return value;
    }
}

