/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;

public final class DivLongsEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DivLongsEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator lhs;
    private final EvalOperator.ExpressionEvaluator rhs;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DivLongsEvaluator(Source source, EvalOperator.ExpressionEvaluator lhs, EvalOperator.ExpressionEvaluator rhs, DriverContext driverContext) {
        this.source = source;
        this.lhs = lhs;
        this.rhs = rhs;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock lhsBlock = (LongBlock)this.lhs.eval(page);){
            LongBlock longBlock;
            block20: {
                LongVector rhsVector;
                LongVector lhsVector;
                LongBlock rhsBlock;
                block18: {
                    LongBlock longBlock2;
                    block19: {
                        block16: {
                            LongBlock longBlock3;
                            block17: {
                                rhsBlock = (LongBlock)this.rhs.eval(page);
                                try {
                                    lhsVector = lhsBlock.asVector();
                                    if (lhsVector != null) break block16;
                                    longBlock3 = this.eval(page.getPositionCount(), lhsBlock, rhsBlock);
                                    if (rhsBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (rhsBlock != null) {
                                        try {
                                            rhsBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rhsBlock.close();
                            }
                            return longBlock3;
                        }
                        rhsVector = rhsBlock.asVector();
                        if (rhsVector != null) break block18;
                        longBlock2 = this.eval(page.getPositionCount(), lhsBlock, rhsBlock);
                        if (rhsBlock == null) break block19;
                        rhsBlock.close();
                    }
                    return longBlock2;
                }
                longBlock = this.eval(page.getPositionCount(), lhsVector, rhsVector);
                if (rhsBlock == null) break block20;
                rhsBlock.close();
            }
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.lhs.baseRamBytesUsed();
        return baseRamBytesUsed += this.rhs.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock lhsBlock, LongBlock rhsBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            block15: for (int p = 0; p < positionCount; ++p) {
                switch (lhsBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block15;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block15;
                    }
                }
                switch (rhsBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block15;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block15;
                    }
                }
                long lhs = lhsBlock.getLong(lhsBlock.getFirstValueIndex(p));
                long rhs = rhsBlock.getLong(rhsBlock.getFirstValueIndex(p));
                try {
                    result.appendLong(Div.processLongs(lhs, rhs));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongVector lhsVector, LongVector rhsVector) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                long lhs = lhsVector.getLong(p);
                long rhs = rhsVector.getLong(p);
                try {
                    result.appendLong(Div.processLongs(lhs, rhs));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "DivLongsEvaluator[lhs=" + String.valueOf(this.lhs) + ", rhs=" + String.valueOf(this.rhs) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.lhs, this.rhs});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory lhs;
        private final EvalOperator.ExpressionEvaluator.Factory rhs;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory lhs, EvalOperator.ExpressionEvaluator.Factory rhs) {
            this.source = source;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public DivLongsEvaluator get(DriverContext context) {
            return new DivLongsEvaluator(this.source, this.lhs.get(context), this.rhs.get(context), context);
        }

        public String toString() {
            return "DivLongsEvaluator[lhs=" + String.valueOf(this.lhs) + ", rhs=" + String.valueOf(this.rhs) + "]";
        }
    }
}

