/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.ExceptionUtils;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;

public abstract class DateTimeArithmeticOperation
extends EsqlArithmeticOperation {
    private final DatetimeArithmeticEvaluator millisEvaluator;
    private final DatetimeArithmeticEvaluator nanosEvaluator;

    DateTimeArithmeticOperation(Source source, Expression left, Expression right, EsqlArithmeticOperation.OperationSymbol op, EsqlArithmeticOperation.BinaryEvaluator ints, EsqlArithmeticOperation.BinaryEvaluator longs, EsqlArithmeticOperation.BinaryEvaluator ulongs, EsqlArithmeticOperation.BinaryEvaluator doubles, DatetimeArithmeticEvaluator millisEvaluator, DatetimeArithmeticEvaluator nanosEvaluator) {
        super(source, left, right, op, ints, longs, ulongs, doubles);
        this.millisEvaluator = millisEvaluator;
        this.nanosEvaluator = nanosEvaluator;
    }

    DateTimeArithmeticOperation(StreamInput in, EsqlArithmeticOperation.OperationSymbol op, EsqlArithmeticOperation.BinaryEvaluator ints, EsqlArithmeticOperation.BinaryEvaluator longs, EsqlArithmeticOperation.BinaryEvaluator ulongs, EsqlArithmeticOperation.BinaryEvaluator doubles, DatetimeArithmeticEvaluator millisEvaluator, DatetimeArithmeticEvaluator nanosEvaluator) throws IOException {
        super(in, op, ints, longs, ulongs, doubles);
        this.millisEvaluator = millisEvaluator;
        this.nanosEvaluator = nanosEvaluator;
    }

    @Override
    protected Expression.TypeResolution resolveInputType(Expression e, TypeResolutions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isType(e, t -> t.isNumeric() || DataType.isDateTimeOrNanosOrTemporal(t) || DataType.isNull(t), this.sourceText(), paramOrdinal, "date_nanos", "datetime", "numeric");
    }

    @Override
    protected Expression.TypeResolution checkCompatibility() {
        DataType leftType = this.left().dataType();
        DataType rightType = this.right().dataType();
        if (DataType.isDateTimeOrNanosOrTemporal(leftType) || DataType.isDateTimeOrNanosOrTemporal(rightType)) {
            if (DataType.isNull(leftType) || DataType.isNull(rightType)) {
                return Expression.TypeResolution.TYPE_RESOLVED;
            }
            if (DataType.isMillisOrNanos(leftType) && DataType.isTemporalAmount(rightType) || DataType.isTemporalAmount(leftType) && DataType.isMillisOrNanos(rightType)) {
                return Expression.TypeResolution.TYPE_RESOLVED;
            }
            if (DataType.isTemporalAmount(leftType) && DataType.isTemporalAmount(rightType) && leftType == rightType) {
                return Expression.TypeResolution.TYPE_RESOLVED;
            }
            return new Expression.TypeResolution(DateTimeArithmeticOperation.formatIncompatibleTypesMessage(this.symbol(), leftType, rightType));
        }
        return super.checkCompatibility();
    }

    abstract Period fold(Period var1, Period var2);

    abstract Duration fold(Duration var1, Duration var2);

    @Override
    public final Object fold(FoldContext ctx) {
        DataType leftDataType = this.left().dataType();
        DataType rightDataType = this.right().dataType();
        if (leftDataType == DataType.DATE_PERIOD && rightDataType == DataType.DATE_PERIOD) {
            Object l = this.left().fold(ctx);
            Object r = this.right().fold(ctx);
            if (l instanceof Collection || r instanceof Collection) {
                return null;
            }
            try {
                return this.fold((Period)l, (Period)r);
            }
            catch (ArithmeticException e) {
                throw ExceptionUtils.math(this.source(), e);
            }
        }
        if (leftDataType == DataType.TIME_DURATION && rightDataType == DataType.TIME_DURATION) {
            Duration l = (Duration)this.left().fold(ctx);
            Duration r = (Duration)this.right().fold(ctx);
            try {
                return this.fold(l, r);
            }
            catch (ArithmeticException e) {
                throw ExceptionUtils.math(this.source(), e);
            }
        }
        if (DataType.isNull(leftDataType) || DataType.isNull(rightDataType)) {
            return null;
        }
        return super.fold(ctx);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        if (this.dataType() == DataType.DATETIME) {
            Expression temporalAmountArgument;
            Expression datetimeArgument;
            if (this.left().dataType() == DataType.DATETIME) {
                datetimeArgument = this.left();
                temporalAmountArgument = this.right();
            } else {
                datetimeArgument = this.right();
                temporalAmountArgument = this.left();
            }
            return this.millisEvaluator.apply(this.source(), toEvaluator.apply(datetimeArgument), (TemporalAmount)temporalAmountArgument.fold(toEvaluator.foldCtx()));
        }
        if (this.dataType() == DataType.DATE_NANOS) {
            Expression temporalAmountArgument;
            Expression dateNanosArgument;
            if (this.left().dataType() == DataType.DATE_NANOS) {
                dateNanosArgument = this.left();
                temporalAmountArgument = this.right();
            } else {
                dateNanosArgument = this.right();
                temporalAmountArgument = this.left();
            }
            return this.nanosEvaluator.apply(this.source(), toEvaluator.apply(dateNanosArgument), (TemporalAmount)temporalAmountArgument.fold(toEvaluator.foldCtx()));
        }
        return super.toEvaluator(toEvaluator);
    }

    static interface DatetimeArithmeticEvaluator {
        public EvalOperator.ExpressionEvaluator.Factory apply(Source var1, EvalOperator.ExpressionEvaluator.Factory var2, TemporalAmount var3);
    }
}

