/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.nulls;

import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.querydsl.query.ExistsQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class IsNotNull
extends UnaryScalarFunction
implements EvaluatorMapper,
Negatable<UnaryScalarFunction>,
TranslationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "IsNotNull", IsNotNull::new);

    @FunctionInfo(description="Returns `false` if the value is `NULL`, `true` otherwise.", note="If a field is only in some documents it will be `NULL` in the documents that did not contain it.", operator="IS NOT NULL", returnType={"double", "integer", "long", "date_nanos", "date_period", "datetime", "time_duration", "unsigned_long", "counter_long", "counter_integer", "counter_double", "dense_vector"}, examples={@Example(file="null", tag="is-not-null")})
    public IsNotNull(Source source, @Param(name="field", description="Value to check. It can be a single- or multi-valued column or an expression.", type={"double", "integer", "long", "date_nanos", "date_period", "datetime", "time_duration", "unsigned_long", "counter_long", "counter_integer", "counter_double", "dense_vector"}) Expression field) {
        super(source, field);
    }

    private IsNotNull(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return IsNotNull.ENTRY.name;
    }

    @Override
    protected NodeInfo<IsNotNull> info() {
        return NodeInfo.create(this, IsNotNull::new, this.field());
    }

    @Override
    protected IsNotNull replaceChild(Expression newChild) {
        return new IsNotNull(this.source(), newChild);
    }

    @Override
    public Object fold(FoldContext ctx) {
        return !DataType.isNull(this.field().dataType()) && this.field().fold(ctx) != null;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return new IsNotNullEvaluatorFactory(toEvaluator.apply(this.field()));
    }

    @Override
    public Nullability nullable() {
        return Nullability.FALSE;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public UnaryScalarFunction negate() {
        return new IsNull(this.source(), this.field());
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return IsNull.isTranslatable(this.field(), pushdownPredicates);
    }

    @Override
    public Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        return new ExistsQuery(this.source(), handler.nameOf(this.field()));
    }

    record IsNotNullEvaluatorFactory(EvalOperator.ExpressionEvaluator.Factory field) implements EvalOperator.ExpressionEvaluator.Factory
    {
        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new IsNotNullEvaluator(context, this.field.get(context));
        }

        @Override
        public String toString() {
            return "IsNotNullEvaluator[field=" + String.valueOf(this.field) + "]";
        }
    }

    record IsNotNullEvaluator(DriverContext driverContext, EvalOperator.ExpressionEvaluator field) implements EvalOperator.ExpressionEvaluator
    {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IsNotNullEvaluator.class);

        public Block eval(Page page) {
            try (Block fieldBlock = this.field.eval(page);){
                BooleanBlock booleanBlock;
                block15: {
                    if (fieldBlock.asVector() != null) {
                        BooleanBlock booleanBlock2 = this.driverContext.blockFactory().newConstantBooleanBlockWith(true, page.getPositionCount());
                        return booleanBlock2;
                    }
                    BooleanVector.FixedBuilder builder = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(page.getPositionCount());
                    try {
                        for (int p = 0; p < page.getPositionCount(); ++p) {
                            builder.appendBoolean(p, !fieldBlock.isNull(p));
                        }
                        booleanBlock = builder.build().asBlock();
                        if (builder == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (builder != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    builder.close();
                }
                return booleanBlock;
            }
        }

        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED + this.field.baseRamBytesUsed();
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.field);
        }

        @Override
        public String toString() {
            return "IsNotNullEvaluator[field=" + String.valueOf(this.field) + "]";
        }
    }
}

