/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.logical;

import java.util.function.BiFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.PredicateBiFunction;

public enum BinaryLogicOperation implements PredicateBiFunction<Boolean, Boolean, Boolean>
{
    AND((l, r) -> {
        if (Boolean.FALSE.equals(l) || Boolean.FALSE.equals(r)) {
            return Boolean.FALSE;
        }
        if (l == null || r == null) {
            return null;
        }
        return Boolean.logicalAnd(l, r);
    }, "AND"),
    OR((l, r) -> {
        if (Boolean.TRUE.equals(l) || Boolean.TRUE.equals(r)) {
            return Boolean.TRUE;
        }
        if (l == null || r == null) {
            return null;
        }
        return Boolean.logicalOr(l, r);
    }, "OR");

    private final BiFunction<Boolean, Boolean, Boolean> process;
    private final String symbol;

    private BinaryLogicOperation(BiFunction<Boolean, Boolean, Boolean> process, String symbol) {
        this.process = process;
        this.symbol = symbol;
    }

    @Override
    public String symbol() {
        return this.symbol;
    }

    @Override
    public Boolean apply(Boolean left, Boolean right) {
        return this.process.apply(left, right);
    }

    @Override
    public final Boolean doApply(Boolean left, Boolean right) {
        return null;
    }

    public String toString() {
        return this.symbol;
    }
}

