/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.logical;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.ScoreOperator;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.esql.core.querydsl.query.BoolQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.expression.predicate.logical.And;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogicOperation;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.score.ExpressionScoreMapper;

public abstract class BinaryLogic
extends BinaryOperator<Boolean, Boolean, Boolean, BinaryLogicOperation>
implements TranslationAware,
ExpressionScoreMapper {
    protected BinaryLogic(Source source, Expression left, Expression right, BinaryLogicOperation operation) {
        super(source, left, right, operation);
    }

    protected BinaryLogic(StreamInput in, BinaryLogicOperation op) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), op);
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.left());
        out.writeNamedWriteable((NamedWriteable)this.right());
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    protected Expression.TypeResolution resolveInputType(Expression e, TypeResolutions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isBoolean(e, this.sourceText(), paramOrdinal);
    }

    @Override
    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }

    @Override
    protected boolean isCommutative() {
        return true;
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return TranslationAware.translatable(this.left(), pushdownPredicates).merge(TranslationAware.translatable(this.right(), pushdownPredicates));
    }

    @Override
    public Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        return BinaryLogic.boolQuery(this.source(), handler.asQuery(pushdownPredicates, this.left()), handler.asQuery(pushdownPredicates, this.right()), this instanceof And);
    }

    public static Query boolQuery(Source source, Query left, Query right, boolean isAnd) {
        BoolQuery bool;
        BoolQuery rightBool;
        BoolQuery leftBool;
        Check.isTrue(left != null || right != null, "Both expressions are null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        List<Query> queries = left instanceof BoolQuery && (leftBool = (BoolQuery)left).isAnd() == isAnd ? (right instanceof BoolQuery && (rightBool = (BoolQuery)right).isAnd() == isAnd ? CollectionUtils.combine(leftBool.queries(), rightBool.queries()) : CollectionUtils.combine(leftBool.queries(), right)) : (right instanceof BoolQuery && (bool = (BoolQuery)right).isAnd() == isAnd ? CollectionUtils.combine(bool.queries(), left) : Arrays.asList(left, right));
        return new BoolQuery(source, isAnd, queries);
    }

    @Override
    public ScoreOperator.ExpressionScorer.Factory toScorer(ExpressionScoreMapper.ToScorer toScorer) {
        return context -> new BinaryLogicScorer(context, toScorer.toScorer(this.left()).get(context), toScorer.toScorer(this.right()).get(context));
    }

    private record BinaryLogicScorer(DriverContext driverContext, ScoreOperator.ExpressionScorer left, ScoreOperator.ExpressionScorer right) implements ScoreOperator.ExpressionScorer
    {
        public DoubleBlock score(Page page) {
            DoubleVector.FixedBuilder builder = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(page.getPositionCount());
            try (DoubleVector leftVector = this.left.score(page).asVector();
                 DoubleVector rightVector = this.right.score(page).asVector();){
                for (int i = 0; i < page.getPositionCount(); ++i) {
                    builder.appendDouble(leftVector.getDouble(i) + rightVector.getDouble(i));
                }
            }
            return builder.build().asBlock();
        }

        public void close() {
            this.left.close();
            this.right.close();
        }
    }
}

