/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.logical;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogicOperation;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Or;

public class And
extends BinaryLogic
implements Negatable<BinaryLogic> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "And", And::new);

    public And(Source source, Expression left, Expression right) {
        super(source, left, right, BinaryLogicOperation.AND);
    }

    private And(StreamInput in) throws IOException {
        super(in, BinaryLogicOperation.AND);
    }

    public String getWriteableName() {
        return And.ENTRY.name;
    }

    @Override
    protected NodeInfo<And> info() {
        return NodeInfo.create(this, And::new, this.left(), this.right());
    }

    @Override
    protected And replaceChildren(Expression newLeft, Expression newRight) {
        return new And(this.source(), newLeft, newRight);
    }

    public And swapLeftAndRight() {
        return new And(this.source(), this.right(), this.left());
    }

    @Override
    public Or negate() {
        return new Or(this.source(), Not.negate(this.left()), Not.negate(this.right()));
    }

    @Override
    protected Expression canonicalize() {
        return Predicates.combineAnd(Predicates.splitAnd(super.canonicalize()));
    }
}

