/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.querydsl.query.RangeQuery;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.DateUtils;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.versionfield.Version;

public class Range
extends ScalarFunction
implements TranslationAware.SingleValueTranslationAware {
    private static final Logger logger = LogManager.getLogger(Range.class);
    private final Expression value;
    private final Expression lower;
    private final Expression upper;
    private final boolean includeLower;
    private final boolean includeUpper;
    private final ZoneId zoneId;

    public Range(Source src, Expression value, Expression lower, boolean inclLower, Expression upper, boolean inclUpper, ZoneId zoneId) {
        super(src, Arrays.asList(value, lower, upper));
        this.value = value;
        this.lower = lower;
        this.upper = upper;
        this.includeLower = inclLower;
        this.includeUpper = inclUpper;
        this.zoneId = zoneId;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected NodeInfo<Range> info() {
        return NodeInfo.create(this, Range::new, this.value, this.lower, this.includeLower, this.upper, this.includeUpper, this.zoneId);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Range(this.source(), newChildren.get(0), newChildren.get(1), this.includeLower, newChildren.get(2), this.includeUpper, this.zoneId);
    }

    public Expression value() {
        return this.value;
    }

    public Expression lower() {
        return this.lower;
    }

    public Expression upper() {
        return this.upper;
    }

    public boolean includeLower() {
        return this.includeLower;
    }

    public boolean includeUpper() {
        return this.includeUpper;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    @Override
    public boolean foldable() {
        if (this.lower.foldable() && this.upper.foldable()) {
            if (this.value().foldable()) {
                return true;
            }
            Expression expression = this.lower();
            if (expression instanceof Literal) {
                Literal l = (Literal)expression;
                expression = this.upper();
                if (expression instanceof Literal) {
                    Literal u = (Literal)expression;
                    return this.areBoundariesInvalid(l.value(), u.value());
                }
            }
        }
        return false;
    }

    @Override
    public Object fold(FoldContext ctx) {
        boolean lowerComparsion;
        Object upperValue;
        Object lowerValue = this.lower.fold(ctx);
        if (this.areBoundariesInvalid(lowerValue, upperValue = this.upper.fold(ctx))) {
            return Boolean.FALSE;
        }
        Object val = this.value.fold(ctx);
        Integer lowerCompare = BinaryComparison.compare(this.lower.fold(ctx), val);
        Integer upperCompare = BinaryComparison.compare(val, this.upper().fold(ctx));
        boolean bl = lowerCompare == null ? false : (this.includeLower ? lowerCompare <= 0 : (lowerComparsion = lowerCompare < 0));
        boolean upperComparsion = upperCompare == null ? false : (this.includeUpper ? upperCompare <= 0 : upperCompare < 0);
        return lowerComparsion && upperComparsion;
    }

    protected boolean areBoundariesInvalid(Object lowerValue, Object upperValue) {
        Integer compare;
        if (DataType.isDateTime(this.value.dataType()) || DataType.isDateTime(this.lower.dataType()) || DataType.isDateTime(this.upper.dataType())) {
            try {
                BytesRef br;
                if (upperValue instanceof BytesRef) {
                    br = (BytesRef)upperValue;
                    upperValue = BytesRefs.toString((Object)br);
                }
                if (upperValue instanceof String) {
                    String upperString = (String)upperValue;
                    upperValue = DateUtils.asDateTime(upperString);
                }
                if (lowerValue instanceof BytesRef) {
                    br = (BytesRef)lowerValue;
                    lowerValue = BytesRefs.toString((Object)br);
                }
                if (lowerValue instanceof String) {
                    String lowerString = (String)lowerValue;
                    lowerValue = DateUtils.asDateTime(lowerString);
                }
            }
            catch (DateTimeException e) {
                return false;
            }
        }
        return (compare = BinaryComparison.compare(lowerValue, upperValue)) != null && (compare > 0 || compare == 0 && (!this.includeLower || !this.includeUpper));
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.includeLower, this.includeUpper, this.value, this.lower, this.upper, this.zoneId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.includeLower, other.includeLower) && Objects.equals(this.includeUpper, other.includeUpper) && Objects.equals(this.value, other.value) && Objects.equals(this.lower, other.lower) && Objects.equals(this.upper, other.upper) && Objects.equals(this.zoneId, other.zoneId);
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return pushdownPredicates.isPushableAttribute(this.value) && this.lower.foldable() && this.upper.foldable() ? TranslationAware.Translatable.YES : TranslationAware.Translatable.NO;
    }

    @Override
    public Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        return this.translate(handler);
    }

    private RangeQuery translate(TranslatorHandler handler) {
        Object l = Foldables.literalValueOf(this.lower);
        Object u = Foldables.literalValueOf(this.upper);
        String format = null;
        DataType dataType = this.value.dataType();
        logger.trace("Translating Range into lucene query.  dataType is [{}] upper is [{}<{}>]  lower is [{}<{}>]", new Object[]{dataType, this.lower, this.lower.dataType(), this.upper, this.upper.dataType()});
        if (dataType == DataType.DATETIME) {
            l = EsqlDataTypeConverter.dateWithTypeToString((Long)l, this.lower.dataType());
            u = EsqlDataTypeConverter.dateWithTypeToString((Long)u, this.upper.dataType());
            format = EsqlDataTypeConverter.DEFAULT_DATE_TIME_FORMATTER.pattern();
        }
        if (dataType == DataType.DATE_NANOS) {
            l = EsqlDataTypeConverter.dateWithTypeToString((Long)l, this.lower.dataType());
            u = EsqlDataTypeConverter.dateWithTypeToString((Long)u, this.upper.dataType());
            format = EsqlDataTypeConverter.DEFAULT_DATE_NANOS_FORMATTER.pattern();
        }
        if (dataType == DataType.IP) {
            BytesRef bytesRef;
            if (l instanceof BytesRef) {
                bytesRef = (BytesRef)l;
                l = EsqlDataTypeConverter.ipToString(bytesRef);
            }
            if (u instanceof BytesRef) {
                bytesRef = (BytesRef)u;
                u = EsqlDataTypeConverter.ipToString(bytesRef);
            }
        } else if (dataType == DataType.VERSION) {
            Version version;
            BytesRef bytesRef;
            if (l instanceof BytesRef) {
                bytesRef = (BytesRef)l;
                l = EsqlDataTypeConverter.versionToString(bytesRef);
            } else if (l instanceof Version) {
                version = (Version)l;
                l = EsqlDataTypeConverter.versionToString(version);
            }
            if (u instanceof BytesRef) {
                bytesRef = (BytesRef)u;
                u = EsqlDataTypeConverter.versionToString(bytesRef);
            } else if (u instanceof Version) {
                version = (Version)u;
                u = EsqlDataTypeConverter.versionToString(version);
            }
        } else if (dataType == DataType.UNSIGNED_LONG) {
            Long ul;
            if (l instanceof Long) {
                ul = (Long)l;
                l = NumericUtils.unsignedLongAsNumber((long)ul);
            }
            if (u instanceof Long) {
                ul = (Long)u;
                u = NumericUtils.unsignedLongAsNumber((long)ul);
            }
        }
        logger.trace("Building range query with format string [{}]", new Object[]{format});
        return new RangeQuery(this.source(), handler.nameOf(this.value), l, this.includeLower(), u, this.includeUpper(), format, this.zoneId);
    }

    @Override
    public Expression singleValueField() {
        return this.value;
    }
}

