/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.TrimEvaluator;

public final class Trim
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Trim", Trim::new);

    @FunctionInfo(returnType={"keyword"}, description="Removes leading and trailing whitespaces from a string.", examples={@Example(file="string", tag="trim")})
    public Trim(Source source, @Param(name="string", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`.") Expression str) {
        super(source, str);
    }

    private Trim(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Trim.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isString(this.field, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory field = toEvaluator.apply(this.field());
        return new TrimEvaluator.Factory(this.source(), field);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Trim(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Trim::new, this.field());
    }

    static BytesRef process(BytesRef val) {
        int offset;
        UnicodeUtil.UTF8CodePoint codePoint = new UnicodeUtil.UTF8CodePoint();
        for (offset = val.offset; offset < val.offset + val.length; offset += codePoint.numBytes) {
            codePoint = UnicodeUtil.codePointAt((byte[])val.bytes, (int)offset, (UnicodeUtil.UTF8CodePoint)codePoint);
            if (!Character.isWhitespace(codePoint.codePoint)) break;
        }
        int end = offset;
        for (int i = offset; i < val.offset + val.length; i += codePoint.numBytes) {
            codePoint = UnicodeUtil.codePointAt((byte[])val.bytes, (int)i, (UnicodeUtil.UTF8CodePoint)codePoint);
            if (Character.isWhitespace(codePoint.codePoint)) continue;
            end = i + codePoint.numBytes;
        }
        return new BytesRef(val.bytes, offset, end - offset);
    }
}

