/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ChangeCase;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.session.Configuration;

public class ToUpper
extends ChangeCase {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToUpper", ToUpper::new);
    private static final TransportVersion ESQL_SERIALIZE_SOURCE_FUNCTIONS_WARNINGS = TransportVersion.fromName((String)"esql_serialize_source_functions_warnings");

    @FunctionInfo(returnType={"keyword"}, description="Returns a new string representing the input string converted to upper case.", examples={@Example(file="string", tag="to_upper")})
    public ToUpper(Source source, @Param(name="str", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`. The input can be a single-valued column or expression,\nor a multi-valued column or expression {applies_to}`stack: ga 9.1.0`.\n") Expression field, Configuration configuration) {
        super(source, field, configuration, ChangeCase.Case.UPPER);
    }

    private ToUpper(StreamInput in) throws IOException {
        this(in.getTransportVersion().supports(ESQL_SERIALIZE_SOURCE_FUNCTIONS_WARNINGS) ? Source.readFrom((PlanStreamInput)in) : Source.EMPTY, (Expression)in.readNamedWriteable(Expression.class), ((PlanStreamInput)in).configuration());
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(ESQL_SERIALIZE_SOURCE_FUNCTIONS_WARNINGS)) {
            this.source().writeTo(out);
        }
        out.writeNamedWriteable((NamedWriteable)this.field());
    }

    public String getWriteableName() {
        return ToUpper.ENTRY.name;
    }

    @Override
    public ToUpper replaceChild(Expression child) {
        return new ToUpper(this.source(), child, this.configuration());
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, ToUpper::new, this.field(), this.configuration());
    }
}

